package tookan.tookanlocationtrackinglibrary.retrofit2;


import android.content.Context;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Rest Client
 */
public class RestClient
{


	public static Retrofit retrofit = null;
	static Integer BKS_KEYSTORE_RAW_FILE_ID = 0;
	// Integer BKS_KEYSTORE_RAW_FILE_ID = R.raw.keystorebks;
	static Integer SSL_KEY_PASSWORD_STRING_ID = 0;
	//Integer SSL_KEY_PASSWORD_STRING_ID = R.string.sslKeyPassword;

	/**
	 * @return
	 */
	public static ApiInterface getApiInterface(Context context)
	{
		if (retrofit == null || !Config.isRelease())
		{

			try
			{
				retrofit = new Retrofit.Builder()
						// .baseUrl("http://52.90.184.241:3000/")
						.baseUrl("https://api2.tookanapp.com:5555/")
						//.baseUrl("https://api.github.com/")
						.addConverterFactory(GsonConverterFactory.create())
						.client(httpClient().build())
						//.client(secureConnection().build())
						.build();
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return retrofit.create(ApiInterface.class);
	}


	/**
	 * @return
	 */
	public static Retrofit getRetrofitBuilder(Context context)
	{
		if (retrofit == null || !Config.isRelease())
		{
			retrofit = new Retrofit.Builder()
					// .baseUrl("http://52.90.184.241:3000/")
					.baseUrl(Config.getServerUrl(context))
					//.baseUrl("https://api.github.com/")
					.addConverterFactory(GsonConverterFactory.create())
					.client(httpClient().build())
					.build();
		}
		return retrofit;
	}

	/**
	 * @return
	 */
	private static OkHttpClient.Builder httpClient()
	{
		HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
		// set your desired log level
		//logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
		logging.setLevel(HttpLoggingInterceptor.Level.BODY);
		OkHttpClient.Builder httpClient = new OkHttpClient.Builder();

		// add your other interceptors …
		// add logging as last interceptor
		httpClient.addInterceptor(logging);
		return httpClient;
	}


}
