package tookan.tookanlocationtrackinglibrary.retrofit2;

import android.content.Context;

import tookan.tookanlocationtrackinglibrary.R;


/**
 * Created by cl-macmini-83 on 19/11/16.
 */
public interface Constants
{
	/**
	 * The messages to be conveyed when an error
	 * is reported as a result of Api Call Failure
	 */
	enum StatusDescription
	{

		CUSTOM(-1),

		NONE(R.string.empty),
		HTTP_ERROR(R.string.http_error),
		CONNECTION_REFUSED(R.string.connection_refused_error),
		SSL_HANDSHAKE_FAILED(R.string.ssl_handshake_error),
		NO_INTERNET(R.string.not_connected_to_internet_text),
		SOCKET_TIMED_OUT(R.string.remote_server_failed_error),
		CONNECTION_TIMED_OUT(R.string.connection_timed_out_error),
		NO_HTTP_RESPONSE(R.string.remote_server_could_not_respond),
		PARSING_ERROR(R.string.an_error_was_procured_while_parsing),
		RUNTIME_ERROR(R.string.an_unexpected_error_occurred),
		UNKNOWN_ERROR_OCCURRED(R.string.an_unexpected_error_occurred),
		CONNECTION_RESET_BY_PEER(R.string.connection_reset_error),
		UNEXPECTED_END_OF_STREAM(R.string.unexpected_end_stream);

		private final int resourceId;
		private String message;

		StatusDescription(int resourceId)
		{
			this.resourceId = resourceId;
		}

		public void setMessage(String message)
		{
			this.message = message;
		}

		public String getMessage(Context context)
		{
			return resourceId == -1 ? message : context.getString(resourceId);
		}
	}


}
