package tookan.tookanlocationtrackinglibrary.metering;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.util.Log;

import com.google.android.gms.location.FusedLocationProviderApi;

import tookan.tookanlocationtrackinglibrary.location.LocationUtils;


public class FusedLocationReceiverBackgroundBalanced extends BroadcastReceiver {

    private static final String TAG = FusedLocationReceiverBackgroundBalanced.class.getSimpleName();

    @Override
    public void onReceive(final Context context, Intent intent) {

        final Location location = (Location) intent.getExtras().get(FusedLocationProviderApi.KEY_LOCATION_CHANGED);

        Log.e(TAG, "onReceive: " + location);

        // Check if the Location is not null
        if (location != null) {
            // Save the Location to the SharedPreferences
            LocationUtils.saveLocation(context, location);

            if (GpsDistanceCalculator.fusedLocationUpdate != null)
                GpsDistanceCalculator.fusedLocationUpdate.onFusedLocationChanged(location);
        }
    }
}