package tookan.tookanlocationtrackinglibrary;

import android.content.Context;
import android.location.Location;
import android.widget.Toast;

import org.eclipse.paho.android.service.MqttAndroidClient;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONException;

import java.io.Serializable;

import tookan.tookanlocationtrackinglibrary.model.TrackingData;
import tookan.tookanlocationtrackinglibrary.retrofit2.APIError;
import tookan.tookanlocationtrackinglibrary.retrofit2.CommonParams;
import tookan.tookanlocationtrackinglibrary.retrofit2.ResponseResolver;
import tookan.tookanlocationtrackinglibrary.retrofit2.RestClient;
import tookan.tookanlocationtrackinglibrary.utils.NetworkUtils;

/**
 * Created by amankaushik on 05/01/17.
 */

public class TookanLocationListeningImpl extends TookanLocationListening
{
	private static LocationListener locationListener;
	private MqttAndroidClient mqttAndroidClient;
	private String trackingId;
	private final String apiKey = "0da4f7ee0ac89bc1dce9a32a43cfdb1d7909cb5a024f217b8a6f783778c4b0b8";

	public TookanLocationListeningImpl(Context context)
	{

	}

	@Override
	public void startLocationListening(final Context context, String jobID, LocationListener listener)
	{
		locationListener = listener;

		if(jobID == null || jobID.isEmpty())
		{
			Toast.makeText(context, "Please provide a valid job ID.", Toast.LENGTH_SHORT).show();
			return;
		}

		if (NetworkUtils.internetCheck(context))
		{
			CommonParams commonParams = new CommonParams.Builder().add("api_key", apiKey).add("job_id", jobID).add("request_type", 1).build();

			RestClient.getApiInterface(context).generateSessionID(commonParams.getMap()).enqueue(new ResponseResolver<TrackingData>(null)
			{
				@Override
				public void success(TrackingData trackingData)
				{
					trackingId = trackingData.getData().getSessionId();

					try
					{
						Location location = new Location("currentLocation");
						location.setLatitude(Double.valueOf(trackingData.getData().getFleet().get(0).getLatitude()));
						location.setLongitude(Double.valueOf(trackingData.getData().getFleet().get(0).getLongitude()));

						locationListener.onLocationArrive(location, null);
					}
					catch (Exception e)
					{

					}
					establishMQTTConnection(context);
				}

				@Override
				public void failure(APIError error)
				{
					Toast.makeText(context, error.getMessage(), Toast.LENGTH_SHORT).show();
				}
			});
		}
		else
		{
			Toast.makeText(context, "Please check your internet connection.", Toast.LENGTH_SHORT).show();
		}

	}

	@Override
	public void stopLocationListening(Context context)
	{
		try
		{
			if (!NetworkUtils.internetCheck(context))
			{
				Toast.makeText(context, "Please check your internet connection.", Toast.LENGTH_SHORT).show();
				return;
			}

			if (mqttAndroidClient != null && mqttAndroidClient.isConnected())
			{
				try
				{
					mqttAndroidClient.unsubscribe(trackingId);
					mqttAndroidClient.disconnect();
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
			}
			else
			{
				Toast.makeText(context, "Location listener already stopped.", Toast.LENGTH_SHORT).show();
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			Toast.makeText(context, "Location listener already stopped.", Toast.LENGTH_SHORT).show();
		}
	}

	private void establishMQTTConnection(final Context context)
	{
		String clientId = MqttClient.generateClientId();
		//test.mosquitto.org
//        tracking.tookan.io
		mqttAndroidClient = new MqttAndroidClient(context, "tcp://tracking.tookan.io", clientId);

		mqttAndroidClient.setCallback(new MqttCallbackExtended()
		{
			@Override
			public void connectComplete(boolean reconnect, String serverURI)
			{
			}

			@Override
			public void connectionLost(Throwable cause)
			{
			}

			@Override
			public void messageArrived(String topic, MqttMessage message) throws Exception
			{
				try
				{
					if (message.toString().contains("NaN"))
					{
						Toast.makeText(context, "Job completed.", Toast.LENGTH_SHORT).show();
						locationListener.onJobComplete();
						stopLocationListening(context);

						return;
					}

					JSONArray jsonArray = new JSONArray(message.toString());
					String location = jsonArray.getJSONObject(0).getString("location");
					JSONArray jsonArray1 = new JSONArray(location);

					Double lat = jsonArray1.getJSONObject(jsonArray1.length() - 1).getDouble("lat");
					Double lng = jsonArray1.getJSONObject(jsonArray1.length() - 1).getDouble("lng");

					Location thisLocation = new Location("thisLocation");
					thisLocation.setLatitude(lat);
					thisLocation.setLongitude(lng);

					locationListener.onLocationArrive(thisLocation, message.toString());
				}
				catch (JSONException e)
				{
					e.printStackTrace();
				}

			}

			@Override
			public void deliveryComplete(IMqttDeliveryToken token)
			{

			}
		});
		MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
		mqttConnectOptions.setAutomaticReconnect(true);
		mqttConnectOptions.setCleanSession(false);

		try
		{
			mqttAndroidClient.connect(mqttConnectOptions, null, new IMqttActionListener()
			{
				@Override
				public void onSuccess(IMqttToken asyncActionToken)
				{
					subscribeLocations();
				}

				@Override
				public void onFailure(IMqttToken asyncActionToken, Throwable exception)
				{
					//Log.d("MQTT ", "MQTT exception" + exception);
				}
			});

		}
		catch (MqttException ex)
		{
			ex.printStackTrace();
		}
	}

	private void subscribeLocations()
	{
		try
		{
			mqttAndroidClient.subscribe(trackingId, 2);
		}
		catch (MqttException e)
		{
			e.printStackTrace();
		}
	}


	public interface LocationListener extends Serializable
	{
		void onLocationArrive(Location latestLocation, String locationData);
		void onJobComplete();
	}
}
