package app.raybritton.tokenstorage

import io.reactivex.Completable
import io.reactivex.Flowable

/**
 * A persistence class should store strings
 */
interface RxPersistence {
    /**
     * Remove all strings and ids
     */
    fun clearAll(): Completable

    /**
     * Remove the string with the matching key (if present)
     */
    fun clear(key: String): Completable

    /**
     * Save the key and value
     */
    fun save(key: String, plaintext: String): Completable

    /**
     * Load the string matching the key, null if none found
     */
    fun load(key: String): Flowable<Optional<String>>

    /**
     * Get all the keys stored
     */
    fun keys(): Flowable<List<String>>
}