package app.raybritton.tokenstorage.gson

import app.raybritton.tokenstorage.persistence.NoRandomAccessPersistence
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.google.gson.stream.JsonWriter
import java.io.File
import java.io.FileReader
import java.io.FileWriter

class GsonPersistence(dir: File,
                      filename: String = "crypto.json",
                      private val gson: Gson = Gson()) : NoRandomAccessPersistence() {
    private var file = File(dir, filename)
    private val typeToken = object : TypeToken<Map<String, String>>() {}

    override fun write(data: Map<String, String>) {
        gson.toJson(data, typeToken.type, JsonWriter(FileWriter(file)))
    }

    override fun read(): Map<String, String> {
        if (!file.exists()) {
            return mapOf()
        }
        return gson.fromJson<Map<String, String>>(FileReader(file), typeToken.type)
    }

}