package app.raybritton.tokenstorage.room

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query

internal const val CRYPTO_TABLE_NAME = "crypto"
internal const val CRYPTO_KEY = "key"
internal const val CRYPTO_VALUE = "value"

@Dao
internal interface CryptoDao {
    @Query("SELECT * FROM $CRYPTO_TABLE_NAME WHERE $CRYPTO_KEY = :key")
    fun get(key: String): Encrypted?

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(encrypted: Encrypted)

    @Query("DELETE FROM $CRYPTO_TABLE_NAME WHERE $CRYPTO_KEY = :key")
    fun delete(key: String)

    @Query("DELETE FROM $CRYPTO_TABLE_NAME")
    fun deleteAll()

    @Query("SELECT $CRYPTO_KEY FROM $CRYPTO_TABLE_NAME")
    fun getKeys(): List<String>
}