package app.raybritton.tokenstorage.moshi

import app.raybritton.tokenstorage.persistence.NoRandomAccessPersistence
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types
import java.io.File

class MoshiPersistence(dir: File,
                      filename: String = "crypto.m.json",
                      moshi: Moshi = Moshi.Builder().build()) : NoRandomAccessPersistence() {
    private var file = File(dir, filename)
    private val adapter = moshi.adapter<Map<String, String>>(Types.newParameterizedType(Map::class.java, String::class.java, String::class.java))

    override fun write(data: Map<String, String>) {
        val contents = adapter.toJson(data)
        file.writeText(contents)
    }

    override fun read(): Map<String, String> {
        if (!file.exists()) {
            return mapOf()
        }
        val contents = file.readText()
        return adapter.fromJson(contents)!!
    }

}