package app.raybritton.tokenstorage.gson

import app.raybritton.tokenstorage.persistence.NoRandomAccessPersistence
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import java.io.File

class GsonPersistence(dir: File,
                      filename: String = "crypto.g.json",
                      private val gson: Gson = Gson()) : NoRandomAccessPersistence() {
    private var file = File(dir, filename)
    private val typeToken = object : TypeToken<Map<String, String>>() {}

    override fun write(data: Map<String, String>) {
        val str = gson.toJson(data)
        file.writeText(str)
    }

    override fun read(): Map<String, String> {
        if (!file.exists()) {
            return mapOf()
        }
        val str = file.readText()
        return gson.fromJson<Map<String, String>>(str, typeToken.type)
    }

}