package app.raybritton.tokenstorage

import android.util.Log

interface CryptoLogging {
    enum class LogLevel {
        NONE, DEBUG, ALL
    }

    fun debug(message: String) {
        if (loggingLevel >= LogLevel.DEBUG) {
            Log.d(TAG, logPrefix() + message)
        }
    }

    fun fine(message: String) {
        if (loggingLevel >= LogLevel.ALL) {
            Log.v(TAG, logPrefix() + message)
        }
    }

    fun Any?.shrink(): String {
        val desc = toString()
        return if (this == null) {
            "null"
        } else if (desc.length > 24) {
            desc.substring(0, 8) + "..." + desc.substring(desc.length - 8, desc.length)
        } else {
            desc
        }
    }

    fun logPrefix(): String = "[${Thread.currentThread().name}]-${this::class.java.simpleName}{${System.identityHashCode(this)}} - "

    companion object {
        private const val TAG = "Crypto"

        var loggingLevel = LogLevel.NONE
    }
}