package app.raybritton.tokenstorage.crypto

/**
 * Used by TokenStorage to encrypt and decrypt strings
 */
interface Crypto {
    /**
     * Called on every call to TokenStorage so this class can
     * check that the crypto is setup
     *
     * If not it should throw an exception
     */
    fun verify()

    fun encrypt(plaintext: String): String
    fun decrypt(encrypted: String): String

    /**
     * This only be called by TokenStorage
     */
    fun reset()
}
