package app.raybritton.tokenstorage

/**
 * This provides an object that represents a single stored string
 *
 * It's main purpose is for helping with patterns like DI
 */
class TokenWrapper(private val tokenStorage: TokenStorage<*,*,*>,
                   val key: String): CryptoLogging {

    fun save(plaintext: String) {
        fine("save(${plaintext.shrink()})")
        tokenStorage.save(key, plaintext)
    }

    fun load(): String? {
        fine("load()")
        return tokenStorage.load(key)
    }

    fun isSet(): Boolean {
        fine("isSet()")
        return tokenStorage.contains(key)
    }

    fun clear() {
        fine("clear()")
        tokenStorage.clear(key)
    }

    override fun logPrefix(): String = "[${Thread.currentThread().name}]-${this::class.java.simpleName}{${System.identityHashCode(this)}}[$key] - "
}