package app.raybritton.tokenstorage.persistence

abstract class NoRandomAccessPersistence : Persistence {
    private lateinit var data : MutableMap<String, String>

    override fun clearAll() {
        verify()
        data.clear()
        writeToDisk()
    }

    override fun clear(key: String) {
        verify()
        data.remove(key)
        writeToDisk()
    }

    override fun save(key: String, encrypted: String) {
        verify()
        data[key] = encrypted
        writeToDisk()
    }

    override fun load(key: String): String? {
        verify()
        return data[key]
    }

    override fun keys(): List<String> {
        verify()
        return data.keys.toList()
    }

    override fun contains(key: String): Boolean {
        verify()
        return data.contains(key)
    }

    private fun verify() {
        if (!this::data.isInitialized) {
            data = read().toMutableMap()
        }
    }

    private fun writeToDisk() {
        write(data)
    }

    override fun reset() {
        data.clear()
    }

    abstract fun write(data: Map<String, String>)

    abstract fun read(): Map<String, String>
}
