package app.pitech.event.provider

import android.content.ContentProvider
import android.content.ContentValues
import android.content.Context
import android.database.Cursor
import android.net.Uri
import android.util.Log
import app.pitech.event.Pipeline
import app.pitech.event.model.Config
import com.google.gson.Gson

/**
 * This content provider is needed as it's automatically invoked when the app which uses the library is started.
 * Having this content provider injected in the app's manifest allows us to skip calling the start() method with the
 * library.
 * Quite a neat hack!
 */
internal class PipelineProvider : ContentProvider() {

    private val TAG: String = javaClass.simpleName

    override fun insert(uri: Uri, values: ContentValues?): Uri? = null

    override fun query(
        uri: Uri,
        projection: Array<String>?,
        selection: String?,
        selectionArgs: Array<String>?,
        sortOrder: String?
    ): Cursor? = null

    override fun onCreate(): Boolean {
        val config = context?.let {
            readConfigJson(it)
        }
        config?.let { cfg ->
            context?.let { context ->
                Pipeline.with(context).start(cfg.apiKey, cfg.baseUrl)
            }
        }
        return false
    }

    override fun update(uri: Uri, values: ContentValues?, selection: String?, selectionArgs: Array<String>?) = 0

    override fun delete(uri: Uri, selection: String?, selectionArgs: Array<String>?) = 0

    override fun getType(uri: Uri): String? = null

    /**
     * Read the config.json from the /res/raw folder and parse it to
     * @return a config object with the type
     * @see Config or null if the json file was not found or the context was null
     * @param context : The application context
     * TODO : debug the case for which context might be null
     */
    private fun readConfigJson(context: Context): Config? {
        try {
            val resId = context.resources.getIdentifier("config", "raw", context.packageName)
            if (resId != 0) {
                val config = context.resources.openRawResource(resId)
                    .bufferedReader().use { it.readText() }

                return Gson().fromJson(config, Config::class.java)
            }
        } catch (e: Exception) {
            Log.e(
                TAG,
                "config.json was not found, either ensure that config.json was properly placed in the /res/raw folder or start the library manually by calling Pipeline.with().start(key,baseUrl)"
            )
            e.printStackTrace()
        }
        return null
    }
}