package app.pitech.event

import android.content.Context
import android.net.ConnectivityManager
import java.util.*
import java.util.concurrent.TimeUnit

/**
 * Checks to see if the device is connected to the network
 * @return true if the device is connected to a network else false
 * @param context Application or activity context
 */
internal fun isNetwork(context: Context): Boolean {
    val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
    val activeNetworkInfo = connectivityManager.activeNetworkInfo
    return activeNetworkInfo != null && activeNetworkInfo.isConnected
}

internal fun getTimeInMillis() = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()).toString()

internal fun getRandomUUID() = UUID.randomUUID().toString()