package app.pitech.event.model

import android.arch.persistence.room.Embedded
import android.arch.persistence.room.Entity
import android.arch.persistence.room.PrimaryKey
import com.google.gson.annotations.SerializedName

@Entity
internal data class Payload(
    var anonymousId: String = "",
    var channel: String = "",
    @Embedded var context: Context = Context(),
    @Embedded var event: Event = Event(),
    @Embedded var extra: Extra = Extra(),
    @PrimaryKey var messageId: String = "",
    var receivedAt: String = "",
    var sentAt: String = "",
    var timestamp: String = "",
    @Embedded var traits: Traits = Traits(),
    var version: String = "",
    @SerializedName("api_key")
    var apiKey: String = ""
)