package app.pitech.event.worker

import android.arch.persistence.room.Room
import android.content.Context
import androidx.work.Worker
import androidx.work.WorkerParameters
import app.pitech.event.Analytics
import app.pitech.event.db.EventDatabase
import app.pitech.event.isNetwork
import kotlin.concurrent.thread

class FireStoredEventsWork(val context: Context, workerParams: WorkerParameters) : Worker(context, workerParams) {

    private val eventDb by lazy {
        Room.databaseBuilder(
            context,
            EventDatabase::class.java, "event360-db"
        ).build()
    }

    override fun doWork(): Result {
        return if (isNetwork(context)) {
            eventDb.eventDao().query().forEach { message ->
                Analytics.of(context).sendEvent(message) {
                    thread {
                        if (it) eventDb.eventDao().delete(message)
                    }
                }
            }
            Result.success()
        } else
            Result.retry()
    }
}