/*
 * Decompiled with CFR 0.152.
 */
package app.pickmaven.businessdays;

import app.pickmaven.businessdays.Holiday;
import app.pickmaven.businessdays.HolidayUtils;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Holidays {
    private List<Holiday> holidays;
    private boolean linkedlistImpl;

    public Holidays() {
        this.holidays = !this.linkedlistImpl ? new ArrayList<Holiday>() : new LinkedList<Holiday>();
    }

    public Holidays(Holidays holidays) {
        this.holidays = new ArrayList<Holiday>(holidays.getHolidays());
    }

    public Holidays(List<LocalDate> holidayList) {
        this.holidays = !this.linkedlistImpl ? new ArrayList<Holiday>(HolidayUtils.toHolidayList(holidayList)) : new LinkedList<Holiday>(HolidayUtils.toHolidayList(holidayList));
    }

    public Holidays(String delimiter, String ... monthsAndDays) {
        List<MonthDay> holidayList = this.getLocalDateListByMonthAndDay(delimiter, monthsAndDays);
        this.holidays = !this.linkedlistImpl ? new ArrayList<Holiday>(HolidayUtils.toHolidayListByMonthDay(holidayList)) : new LinkedList<Holiday>(HolidayUtils.toHolidayListByMonthDay(holidayList));
    }

    public Holidays(String dayMonthDelimiter, String dateDelimiter, String holidayList) {
        this.holidays = !this.linkedlistImpl ? new ArrayList<Holiday>(HolidayUtils.toHolidayList(dayMonthDelimiter, dateDelimiter, holidayList)) : new LinkedList<Holiday>(HolidayUtils.toHolidayList(dayMonthDelimiter, dateDelimiter, holidayList));
    }

    private List<MonthDay> getLocalDateListByMonthAndDay(String delimiter, String[] monthsAndDays) {
        List<String> holidayList = Arrays.asList(monthsAndDays);
        return holidayList.stream().map(el -> el.trim().split(delimiter)).map(el -> MonthDay.of(Integer.valueOf(el[0].trim()), (int)Integer.valueOf(el[1].trim()))).collect(Collectors.toList());
    }

    public void add(Holiday holiday) {
        assert (Objects.nonNull(holiday)) : "app.pickmaven.businessdays.Holiday to add must be non null";
        this.holidays.add(holiday);
    }

    public boolean remove(Holiday holiday) {
        assert (Objects.nonNull(holiday)) : "app.pickmaven.businessdays.Holiday to remove must be non null";
        return this.holidays.remove(holiday);
    }

    public boolean contains(Holiday holiday) {
        assert (Objects.nonNull(holiday)) : "app.pickmaven.businessdays.Holiday to verify must be non null";
        return this.holidays.contains(holiday);
    }

    public boolean containsAll(Holidays holidayList) {
        assert (Objects.nonNull(holidayList)) : "app.pickmaven.businessdays.Holidays to verify must be non null";
        assert (holidayList.size() <= this.holidays.size()) : "app.pickmaven.businessdays.Holidays to verify exceed in size";
        return this.holidays.containsAll(holidayList.getHolidays());
    }

    public int size() {
        return this.holidays.size();
    }

    public Holidays asLinkedList() {
        this.linkedlistImpl = true;
        return this;
    }

    public List<Holiday> getHolidays() {
        return new ArrayList<Holiday>(this.holidays);
    }

    public Holiday get(int i) {
        return this.holidays.get(i);
    }

    public String getAsString(int i, DateTimeFormatter formatter) {
        return this.get(i).getDate().format(formatter);
    }

    public boolean removeIf(Predicate<? super Holiday> filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<Holiday> each = this.holidays.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.next())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    public Stream<Holiday> stream() {
        return this.holidays.stream();
    }

    public boolean addAll(Holidays holidays) {
        return this.holidays.addAll(holidays.getHolidays());
    }
}

