/*
 * Decompiled with CFR 0.152.
 */
package app.cash.paparazzi.gradle;

import app.cash.paparazzi.gradle.PaparazziPlugin;
import app.cash.paparazzi.gradle.PrepareResourcesTask;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.tasks.MergeResources;
import java.net.URI;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lapp/cash/paparazzi/gradle/PaparazziPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "paparazzi-gradle-plugin"})
public final class PaparazziPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = project.getPlugins().hasPlugin("com.android.library");
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The Android Gradle library plugin must be applied before the Paparazzi plugin.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Configuration configuration = project.getConfigurations().getByName("testImplementation");
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ame(\"testImplementation\")");
        configuration.getDependencies().add((Object)project.getDependencies().create((Object)"app.cash.paparazzi:paparazzi:0.5.2"));
        Object object = project.getExtensions().getByType(LibraryExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026aryExtension::class.java)");
        DefaultDomainObjectSet variants = ((LibraryExtension)object).getLibraryVariants();
        variants.all((Action)new Action<LibraryVariant>(project){
            final /* synthetic */ Project $project;

            public final void execute(LibraryVariant variant) {
                LibraryVariant libraryVariant = variant;
                Intrinsics.checkNotNullExpressionValue((Object)libraryVariant, (String)"variant");
                String string = libraryVariant.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
                String variantSlug = StringsKt.capitalize((String)string, (Locale)locale);
                TaskProvider writeResourcesTask2 = this.$project.getTasks().register("preparePaparazzi" + variantSlug + "Resources", PrepareResourcesTask.class, (Action)new Action<PrepareResourcesTask>(this, variant){
                    final /* synthetic */ apply.2 this$0;
                    final /* synthetic */ LibraryVariant $variant;

                    public final void execute(PrepareResourcesTask it) {
                        PrepareResourcesTask prepareResourcesTask = it;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)prepareResourcesTask), (String)"it");
                        prepareResourcesTask.getOutputs().file((Object)(this.this$0.$project.getBuildDir() + "/intermediates/paparazzi/resources.txt"));
                        LibraryVariant libraryVariant = this.$variant;
                        Intrinsics.checkNotNullExpressionValue((Object)libraryVariant, (String)"variant");
                        TaskProvider taskProvider = libraryVariant.getMergeResourcesProvider();
                        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"variant.mergeResourcesProvider");
                        it.setMergeResourcesProvider$paparazzi_gradle_plugin((TaskProvider<MergeResources>)taskProvider);
                        ProjectLayout projectLayout = this.this$0.$project.getLayout();
                        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
                        Provider provider = projectLayout.getBuildDirectory().dir("intermediates/paparazzi/resources.txt");
                        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026paparazzi/resources.txt\")");
                        it.setOutputDir$paparazzi_gradle_plugin((Provider<Directory>)provider);
                        Object[] objectArray = new Object[1];
                        LibraryVariant libraryVariant2 = this.$variant;
                        Intrinsics.checkNotNullExpressionValue((Object)libraryVariant2, (String)"variant");
                        objectArray[0] = libraryVariant2.getMergeResourcesProvider();
                        it.dependsOn(objectArray);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$variant = libraryVariant;
                    }
                });
                UnitTestVariant unitTestVariant = variant.getUnitTestVariant();
                Intrinsics.checkNotNullExpressionValue((Object)unitTestVariant, (String)"variant.unitTestVariant");
                String string2 = unitTestVariant.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.unitTestVariant.name");
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"Locale.US");
                String testVariantSlug = StringsKt.capitalize((String)string2, (Locale)locale2);
                this.$project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(this, testVariantSlug, writeResourcesTask2){
                    final /* synthetic */ apply.2 this$0;
                    final /* synthetic */ String $testVariantSlug;
                    final /* synthetic */ TaskProvider $writeResourcesTask;

                    public final void execute(JavaBasePlugin it) {
                        this.this$0.$project.getTasks().named("compile" + this.$testVariantSlug + "JavaWithJavac").configure((Action)new Action<Task>(this){
                            final /* synthetic */ apply.1 this$0;

                            public final void execute(Task it) {
                                it.dependsOn(new Object[]{this.this$0.$writeResourcesTask});
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$testVariantSlug = string;
                        this.$writeResourcesTask = taskProvider;
                    }
                });
                this.$project.getPlugins().withType(KotlinBasePluginWrapper.class, (Action)new Action<KotlinBasePluginWrapper>(this, testVariantSlug, writeResourcesTask2){
                    final /* synthetic */ apply.2 this$0;
                    final /* synthetic */ String $testVariantSlug;
                    final /* synthetic */ TaskProvider $writeResourcesTask;

                    public final void execute(KotlinBasePluginWrapper it) {
                        this.this$0.$project.getTasks().named("compile" + this.$testVariantSlug + "Kotlin").configure((Action)new Action<Task>(this){
                            final /* synthetic */ apply.2 this$0;

                            public final void execute(Task it) {
                                it.dependsOn(new Object[]{this.this$0.$writeResourcesTask});
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$testVariantSlug = string;
                        this.$writeResourcesTask = taskProvider;
                    }
                });
                TaskProvider recordTaskProvider = this.$project.getTasks().register("recordPaparazzi" + variantSlug);
                TaskProvider verifyTaskProvider = this.$project.getTasks().register("verifyPaparazzi" + variantSlug);
                TaskProvider testTaskProvider2 = this.$project.getTasks().named("test" + testVariantSlug, Test.class, (Action)new Action<Test>(this, recordTaskProvider, verifyTaskProvider){
                    final /* synthetic */ apply.2 this$0;
                    final /* synthetic */ TaskProvider $recordTaskProvider;
                    final /* synthetic */ TaskProvider $verifyTaskProvider;

                    public final void execute(Test test) {
                        test.doFirst((Action)new Action<Task>(this, test){
                            final /* synthetic */ apply.testTaskProvider.1 this$0;
                            final /* synthetic */ Test $test;

                            public final void execute(Task it) {
                                Gradle gradle = this.this$0.this$0.$project.getGradle();
                                Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
                                this.$test.systemProperty("paparazzi.test.record", (Object)gradle.getTaskGraph().hasTask((Task)this.this$0.$recordTaskProvider.get()));
                                Gradle gradle2 = this.this$0.this$0.$project.getGradle();
                                Intrinsics.checkNotNullExpressionValue((Object)gradle2, (String)"project.gradle");
                                this.$test.systemProperty("paparazzi.test.verify", (Object)gradle2.getTaskGraph().hasTask((Task)this.this$0.$verifyTaskProvider.get()));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$test = test;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$recordTaskProvider = taskProvider;
                        this.$verifyTaskProvider = taskProvider2;
                    }
                });
                recordTaskProvider.configure((Action)new Action<Task>(testTaskProvider2){
                    final /* synthetic */ TaskProvider $testTaskProvider;

                    public final void execute(Task it) {
                        it.dependsOn(new Object[]{this.$testTaskProvider});
                    }
                    {
                        this.$testTaskProvider = taskProvider;
                    }
                });
                verifyTaskProvider.configure((Action)new Action<Task>(testTaskProvider2){
                    final /* synthetic */ TaskProvider $testTaskProvider;

                    public final void execute(Task it) {
                        it.dependsOn(new Object[]{this.$testTaskProvider});
                    }
                    {
                        this.$testTaskProvider = taskProvider;
                    }
                });
                testTaskProvider2.configure((Action)new Action<Test>(this){
                    final /* synthetic */ apply.2 this$0;

                    public final void execute(Test it) {
                        it.doLast((Action)new Action<Task>(this){
                            final /* synthetic */ apply.5 this$0;

                            public final void execute(Task it) {
                                URI uri = this.this$0.this$0.$project.getBuildDir().toPath().resolve("reports/paparazzi/index.html").toUri();
                                this.this$0.this$0.$project.getLogger().log(LogLevel.LIFECYCLE, "See the Paparazzi report at: " + uri);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = project;
            }
        });
    }
}

