/*
 * Decompiled with CFR 0.152.
 */
package app.brant.amazonappstorepublisher.edits;

import app.brant.amazonappstorepublisher.PublishPlugin;
import app.brant.amazonappstorepublisher.edits.Edit;
import app.brant.amazonappstorepublisher.fetchtoken.Token;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0014H\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lapp/brant/amazonappstorepublisher/edits/EditsService;", "", "token", "Lapp/brant/amazonappstorepublisher/fetchtoken/Token;", "version", "", "applicationId", "(Lapp/brant/amazonappstorepublisher/fetchtoken/Token;Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "getToken", "()Lapp/brant/amazonappstorepublisher/fetchtoken/Token;", "getVersion", "createEdit", "Lapp/brant/amazonappstorepublisher/edits/Edit;", "deleteEdit", "", "edit", "extractEditData", "response", "Lretrofit2/Response;", "getActiveEdit", "CreateEdit", "DeleteEdit", "GetActiveEdit", "plugin"})
public final class EditsService {
    @NotNull
    private final Token token;
    @NotNull
    private final String version;
    @NotNull
    private final String applicationId;

    @Nullable
    public final Edit getActiveEdit() {
        GetActiveEdit activeEdit = (GetActiveEdit)PublishPlugin.Companion.getRetrofit().create(GetActiveEdit.class);
        Response response = activeEdit.getActiveEdit("Bearer " + this.token.getAccess_token(), this.version, this.applicationId).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"activeEdit.getActiveEdit\u2026 applicationId).execute()");
        Response response2 = response;
        return this.extractEditData((Response<Edit>)response2);
    }

    @Nullable
    public final Edit createEdit() {
        CreateEdit editsService = (CreateEdit)PublishPlugin.Companion.getRetrofit().create(CreateEdit.class);
        Response response = editsService.createEdit("Bearer " + this.token.getAccess_token(), this.version, this.applicationId).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"editsService.createEdit(\u2026ionId\n        ).execute()");
        Response response2 = response;
        return this.extractEditData((Response<Edit>)response2);
    }

    public final boolean deleteEdit(@NotNull Edit edit) {
        Intrinsics.checkParameterIsNotNull((Object)edit, (String)"edit");
        DeleteEdit editsService = (DeleteEdit)PublishPlugin.Companion.getRetrofit().create(DeleteEdit.class);
        Response response = editsService.deleteEdit("Bearer " + this.token.getAccess_token(), edit.getETag(), this.version, this.applicationId, edit.getId()).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"editsService.deleteEdit(\u2026       edit.id).execute()");
        Response response2 = response;
        return response2.isSuccessful();
    }

    private final Edit extractEditData(Response<Edit> response) {
        Edit activeEdit = (Edit)response.body();
        if (activeEdit != null && response.headers().get("ETag") != null) {
            String string = response.headers().get("ETag");
            if (string == null) {
                Intrinsics.throwNpe();
            }
            activeEdit.setETag(string);
        }
        return activeEdit;
    }

    @NotNull
    public final Token getToken() {
        return this.token;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    public EditsService(@NotNull Token token, @NotNull String version, @NotNull String applicationId) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        this.token = token;
        this.version = version;
        this.applicationId = applicationId;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J.\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H'\u00a8\u0006\t"}, d2={"Lapp/brant/amazonappstorepublisher/edits/EditsService$GetActiveEdit;", "", "getActiveEdit", "Lretrofit2/Call;", "Lapp/brant/amazonappstorepublisher/edits/Edit;", "authorization", "", "version", "applicationId", "plugin"})
    public static interface GetActiveEdit {
        @GET(value="{version}/applications/{appId}/edits")
        @NotNull
        public Call<Edit> getActiveEdit(@Header(value="Authorization") @NotNull String var1, @Path(value="version") @NotNull String var2, @Path(value="appId") @NotNull String var3);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H'\u00a8\u0006\t"}, d2={"Lapp/brant/amazonappstorepublisher/edits/EditsService$CreateEdit;", "", "createEdit", "Lretrofit2/Call;", "Lapp/brant/amazonappstorepublisher/edits/Edit;", "authorization", "", "version", "applicationId", "plugin"})
    public static interface CreateEdit {
        @POST(value="{version}/applications/{appId}/edits")
        @NotNull
        public Call<Edit> createEdit(@Header(value="Authorization") @NotNull String var1, @Path(value="version") @NotNull String var2, @Path(value="appId") @NotNull String var3);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J@\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u0006H'\u00a8\u0006\u000b"}, d2={"Lapp/brant/amazonappstorepublisher/edits/EditsService$DeleteEdit;", "", "deleteEdit", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "authorization", "", "eTag", "version", "applicationId", "editId", "plugin"})
    public static interface DeleteEdit {
        @DELETE(value="{version}/applications/{appId}/edits/{editId}")
        @NotNull
        public Call<ResponseBody> deleteEdit(@Header(value="Authorization") @NotNull String var1, @Header(value="If-Match") @NotNull String var2, @Path(value="version") @NotNull String var3, @Path(value="appId") @NotNull String var4, @Path(value="editId") @NotNull String var5);
    }
}

