/*
 * Decompiled with CFR 0.152.
 */
package app.brant.amazonappstorepublisher.apks;

import app.brant.amazonappstorepublisher.PublishPlugin;
import app.brant.amazonappstorepublisher.apks.Apk;
import app.brant.amazonappstorepublisher.apks.ApkAssetResource;
import app.brant.amazonappstorepublisher.edits.Edit;
import app.brant.amazonappstorepublisher.fetchtoken.Token;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004 !\"#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000f\u001a\u00020\u0005J \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006$"}, d2={"Lapp/brant/amazonappstorepublisher/apks/ApkService;", "", "token", "Lapp/brant/amazonappstorepublisher/fetchtoken/Token;", "version", "", "applicationId", "(Lapp/brant/amazonappstorepublisher/fetchtoken/Token;Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "getToken", "()Lapp/brant/amazonappstorepublisher/fetchtoken/Token;", "getVersion", "attachApkToEdit", "", "editId", "Lapp/brant/amazonappstorepublisher/edits/Edit;", "apkAssetResource", "Lapp/brant/amazonappstorepublisher/apks/ApkAssetResource;", "deleteApk", "apkId", "extractApkData", "", "Lapp/brant/amazonappstorepublisher/apks/Apk;", "response", "Lretrofit2/Response;", "getApk", "getApks", "uploadApk", "apk", "Ljava/io/File;", "filename", "AttachApk", "DeleteApk", "GetApks", "UploadApk", "plugin"})
public final class ApkService {
    @NotNull
    private final Token token;
    @NotNull
    private final String version;
    @NotNull
    private final String applicationId;

    @NotNull
    public final Apk getApk(@NotNull String editId, @NotNull String apkId) {
        Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)apkId, (String)"apkId");
        GetApks getApksService = (GetApks)PublishPlugin.Companion.getRetrofit().create(GetApks.class);
        Response response = getApksService.getApkForEdit("Bearer " + this.token.getAccess_token(), this.version, this.applicationId, editId, apkId).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"getApksService.getApkFor\u2026apkId\n        ).execute()");
        Response response2 = response;
        Object object = response2.body();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"response.body()!!");
        Apk apk = (Apk)object;
        String string = response2.headers().get("ETag");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.headers().get(\"ETag\")!!");
        String eTag = string;
        return new Apk(apk.getVersionCode(), apk.getId(), apk.getName(), eTag);
    }

    @NotNull
    public final List<Apk> getApks(@NotNull String editId) {
        Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
        GetApks getApksService = (GetApks)PublishPlugin.Companion.getRetrofit().create(GetApks.class);
        Response response = getApksService.getApksForEdit("Bearer " + this.token.getAccess_token(), this.version, this.applicationId, editId).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"getApksService.getApksFo\u2026ditId\n        ).execute()");
        Response response2 = response;
        return this.extractApkData((Response<List<Apk>>)response2);
    }

    public final boolean deleteApk(@NotNull String editId, @NotNull String apkId) {
        Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)apkId, (String)"apkId");
        Apk apk = this.getApk(editId, apkId);
        DeleteApk deleteApkService = (DeleteApk)PublishPlugin.Companion.getRetrofit().create(DeleteApk.class);
        Response response = deleteApkService.deleteApk("Bearer " + this.token.getAccess_token(), apk.getETag(), this.version, this.applicationId, editId, apkId).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"deleteApkService.deleteA\u2026              ).execute()");
        Response response2 = response;
        return response2.isSuccessful();
    }

    public final boolean uploadApk(@NotNull String editId, @NotNull File apk, @Nullable String filename) {
        Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)apk, (String)"apk");
        UploadApk uploadApkService = (UploadApk)PublishPlugin.Companion.getRetrofit().create(UploadApk.class);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])FilesKt.readBytes((File)apk));
        Intrinsics.checkExpressionValueIsNotNull((Object)requestBody, (String)"RequestBody.create(\n    \u2026apk.readBytes()\n        )");
        RequestBody requestBody2 = requestBody;
        Response response = uploadApkService.uploadApk("Bearer " + this.token.getAccess_token(), filename, this.version, this.applicationId, editId, requestBody2).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"uploadApkService.uploadA\u2026              ).execute()");
        Response response2 = response;
        return response2.isSuccessful();
    }

    public final boolean attachApkToEdit(@NotNull Edit editId, @NotNull ApkAssetResource apkAssetResource) {
        Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
        Intrinsics.checkParameterIsNotNull((Object)apkAssetResource, (String)"apkAssetResource");
        AttachApk attachApkService = (AttachApk)PublishPlugin.Companion.getRetrofit().create(AttachApk.class);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)Json.Companion.stringify((SerializationStrategy)ApkAssetResource.Companion.serializer(), (Object)apkAssetResource));
        Intrinsics.checkExpressionValueIsNotNull((Object)requestBody, (String)"RequestBody.create(\n    \u2026kAssetResource)\n        )");
        RequestBody requestBody2 = requestBody;
        Response response = attachApkService.attachApkToEdit("Bearer " + this.token.getAccess_token(), this.version, this.applicationId, editId.getId(), requestBody2).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"attachApkService.attachA\u2026              ).execute()");
        Response response2 = response;
        return response2.isSuccessful();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Apk> extractApkData(Response<List<Apk>> response) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List list;
        List list2 = list = (List)response.body();
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Apk apk = (Apk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Apk apk2 = new Apk(it.getVersionCode(), it.getId(), it.getName(), null, 8, null);
            collection.add(apk2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Token getToken() {
        return this.token;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    public ApkService(@NotNull Token token, @NotNull String version, @NotNull String applicationId) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        this.token = token;
        this.version = version;
        this.applicationId = applicationId;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\bf\u0018\u00002\u00020\u0001J@\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u0006H'J<\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u0006H'\u00a8\u0006\r"}, d2={"Lapp/brant/amazonappstorepublisher/apks/ApkService$GetApks;", "", "getApkForEdit", "Lretrofit2/Call;", "Lapp/brant/amazonappstorepublisher/apks/Apk;", "authorization", "", "version", "applicationId", "editId", "apkId", "getApksForEdit", "", "plugin"})
    public static interface GetApks {
        @GET(value="{version}/applications/{appId}/edits/{editId}/apks")
        @NotNull
        public Call<List<Apk>> getApksForEdit(@Header(value="Authorization") @NotNull String var1, @Path(value="version") @NotNull String var2, @Path(value="appId") @NotNull String var3, @Path(value="editId") @NotNull String var4);

        @GET(value="{version}/applications/{appId}/edits/{editId}/apks/{apkId}")
        @NotNull
        public Call<Apk> getApkForEdit(@Header(value="Authorization") @NotNull String var1, @Path(value="version") @NotNull String var2, @Path(value="appId") @NotNull String var3, @Path(value="editId") @NotNull String var4, @Path(value="apkId") @NotNull String var5);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001JL\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\fH'\u00a8\u0006\r"}, d2={"Lapp/brant/amazonappstorepublisher/apks/ApkService$UploadApk;", "", "uploadApk", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "authorization", "", "filename", "version", "applicationId", "editId", "file", "Lokhttp3/RequestBody;", "plugin"})
    public static interface UploadApk {
        @Headers(value={"Content-Type: application/vnd.android.package-archive"})
        @POST(value="{version}/applications/{appId}/edits/{editId}/apks/upload")
        @NotNull
        public Call<ResponseBody> uploadApk(@Header(value="Authorization") @NotNull String var1, @Header(value="filename") @Nullable String var2, @Path(value="version") @NotNull String var3, @Path(value="appId") @NotNull String var4, @Path(value="editId") @NotNull String var5, @Body @NotNull RequestBody var6);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001JJ\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\u0006H'\u00a8\u0006\f"}, d2={"Lapp/brant/amazonappstorepublisher/apks/ApkService$DeleteApk;", "", "deleteApk", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "authorization", "", "eTag", "version", "applicationId", "editId", "apkId", "plugin"})
    public static interface DeleteApk {
        @DELETE(value="{version}/applications/{appId}/edits/{editId}/apks/{apkId}")
        @NotNull
        public Call<ResponseBody> deleteApk(@Header(value="Authorization") @NotNull String var1, @Header(value="If-Match") @NotNull String var2, @Path(value="version") @NotNull String var3, @Path(value="appId") @NotNull String var4, @Path(value="editId") @NotNull String var5, @Path(value="apkId") @NotNull String var6);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J@\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u000bH'\u00a8\u0006\f"}, d2={"Lapp/brant/amazonappstorepublisher/apks/ApkService$AttachApk;", "", "attachApkToEdit", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "authorization", "", "version", "applicationId", "editId", "apkAsset", "Lokhttp3/RequestBody;", "plugin"})
    public static interface AttachApk {
        @POST(value="{version}/applications/{appId}/edits/{editId}/apks/attach")
        @NotNull
        public Call<ResponseBody> attachApkToEdit(@Header(value="Authorization") @NotNull String var1, @Path(value="version") @NotNull String var2, @Path(value="appId") @NotNull String var3, @Path(value="editId") @NotNull String var4, @Body @NotNull RequestBody var5);
    }
}

