/*
 * Decompiled with CFR 0.152.
 */
package app.brant.amazonappstorepublisher;

import app.brant.amazonappstorepublisher.PublishPlugin$apply$;
import app.brant.amazonappstorepublisher.PublishPluginExtension;
import app.brant.amazonappstorepublisher.apks.Apk;
import app.brant.amazonappstorepublisher.apks.ApkService;
import app.brant.amazonappstorepublisher.edits.Edit;
import app.brant.amazonappstorepublisher.edits.EditsService;
import app.brant.amazonappstorepublisher.fetchtoken.FetchTokenService;
import app.brant.amazonappstorepublisher.fetchtoken.Token;
import com.jakewharton.retrofit2.converter.kotlinx.serialization.KotlinSerializationConverterFactory;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.naming.ConfigurationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.kotlin.dsl.TaskContainerScope;
import org.jetbrains.annotations.NotNull;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lapp/brant/amazonappstorepublisher/PublishPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "deleteExistingApksOnEdit", "apkService", "Lapp/brant/amazonappstorepublisher/apks/ApkService;", "activeEdit", "Lapp/brant/amazonappstorepublisher/edits/Edit;", "uploadApksAndAttachToEdit", "apksToUpload", "", "Ljava/io/File;", "validateInputs", "amazon", "Lapp/brant/amazonappstorepublisher/PublishPluginExtension;", "Companion", "plugin"})
public final class PublishPlugin
implements Plugin<Project> {
    private static final MediaType contentType;
    @NotNull
    public static final String apiVersion = "v1";
    @NotNull
    public static final String pluginDslRoot = "amazon";
    @NotNull
    private static final Retrofit retrofit;
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        TaskContainer taskContainer;
        Project project2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project $this$run = project2 = project;
        boolean bl = false;
        PublishPluginExtension amazon = (PublishPluginExtension)$this$run.getExtensions().create(pluginDslRoot, PublishPluginExtension.class, new Object[0]);
        TaskContainer taskContainer2 = $this$run.getTasks();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer2, (String)"tasks");
        TaskContainer $receiver$iv = taskContainer2;
        boolean $i$f$invoke = false;
        TaskContainer $receiver$iv2 = taskContainer = $receiver$iv;
        boolean bl2 = false;
        TaskContainerScope $this$invoke = TaskContainerScope.Companion.of($receiver$iv2);
        boolean bl3 = false;
        $this$invoke.register("publishToAmazonAppStore", (Action)new Action<Task>(amazon, this){
            final /* synthetic */ PublishPluginExtension $amazon$inlined;
            final /* synthetic */ PublishPlugin this$0;
            {
                this.$amazon$inlined = publishPluginExtension;
                this.this$0 = publishPlugin;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkParameterIsNotNull((Object)$this$register, (String)"$receiver");
                $this$register.setGroup("publishing");
                $this$register.setDescription("Uploads APKs to the Amazon App Store.");
                $this$register.doLast((Action)new Action<Task>(this){
                    final /* synthetic */ apply$$inlined$run$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void execute(@NotNull Task $this$doLast) {
                        Edit newEdit;
                        Intrinsics.checkParameterIsNotNull((Object)$this$doLast, (String)"$receiver");
                        PublishPlugin.access$validateInputs(this.this$0.this$0, this.this$0.$amazon$inlined);
                        File file = this.this$0.$amazon$inlined.getSecurityProfile();
                        if (file == null) {
                            Intrinsics.throwNpe();
                        }
                        File securityProfile = file;
                        String string = this.this$0.$amazon$inlined.getApplicationId();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        String applicationId = string;
                        String string2 = "\ufe0f\ud83d\udd12 Authenticating...";
                        System.out.println((Object)string2);
                        Token token = new FetchTokenService().fetchToken(securityProfile);
                        if (token == null) {
                            Intrinsics.throwNpe();
                        }
                        Token token2 = token;
                        EditsService editsService = new EditsService(token2, "v1", applicationId);
                        ApkService apkService = new ApkService(token2, "v1", applicationId);
                        Edit activeEdit = editsService.getActiveEdit();
                        if (this.this$0.$amazon$inlined.getReplaceEdit()) {
                            CharSequence charSequence = "\ufe0f\u2195\ufe0f\ufe0f Replacing edit...";
                            System.out.println(charSequence);
                            if (activeEdit != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)activeEdit.getId()))) {
                                editsService.deleteEdit(activeEdit);
                            }
                        }
                        if ((newEdit = editsService.getActiveEdit()) == null || StringsKt.isBlank((CharSequence)newEdit.getId())) {
                            String string3 = "\ufe0f\ud83c\udd95\ufe0f Creating new edit...";
                            System.out.println((Object)string3);
                            newEdit = editsService.createEdit();
                        }
                        PublishPlugin publishPlugin = this.this$0.this$0;
                        Edit edit = newEdit;
                        if (edit == null) {
                            Intrinsics.throwNpe();
                        }
                        PublishPlugin.access$deleteExistingApksOnEdit(publishPlugin, apkService, edit);
                        PublishPlugin.access$uploadApksAndAttachToEdit(this.this$0.this$0, apkService, newEdit, this.this$0.$amazon$inlined.getPathToApks());
                    }
                });
            }
        });
    }

    private final void validateInputs(PublishPluginExtension amazon) {
        if (amazon.getSecurityProfile() == null) {
            throw (Throwable)new ConfigurationException("Missing required path to LWA security profile");
        }
        if (amazon.getApplicationId() == null) {
            throw (Throwable)new ConfigurationException("Specify your apps application identifier");
        }
        if (amazon.getPathToApks().isEmpty()) {
            throw (Throwable)new ConfigurationException("No APKs to upload");
        }
    }

    private final void deleteExistingApksOnEdit(ApkService apkService, Edit activeEdit) {
        List<Apk> apks = apkService.getApks(activeEdit.getId());
        String string = "\u2b05\ufe0f Remove APKs from previous edit...";
        System.out.println((Object)string);
        Iterable $receiver$iv = apks;
        for (Object element$iv : $receiver$iv) {
            Apk it = (Apk)element$iv;
            boolean bl = false;
            apkService.deleteApk(activeEdit.getId(), it.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void uploadApksAndAttachToEdit(ApkService apkService, Edit activeEdit, List<? extends File> apksToUpload) {
        Iterable $receiver$iv = apksToUpload;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            String string;
            void apk;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            File file = (File)item$iv;
            int index = n2;
            boolean bl = false;
            String string2 = "\u23eb Uploading new APK(s)...";
            System.out.println((Object)string2);
            boolean result = apkService.uploadApk(activeEdit.getId(), (File)apk, "APK-" + index);
            if (result) {
                string = "\ud83c\udf89 New APK(s) published to the Amazon App Store...";
                System.out.println((Object)string);
                continue;
            }
            string = "\u274c Failed to upload new APK(s)...";
            System.out.println((Object)string);
            throw (Throwable)new IllegalStateException("Failed to upload new APK(s)...");
        }
    }

    static {
        Companion = new Companion(null);
        MediaType mediaType = MediaType.get((String)"application/json");
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaType, (String)"MediaType.get(\"application/json\")");
        contentType = mediaType;
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://developer.amazon.com/api/appstore/").addConverterFactory(KotlinSerializationConverterFactory.create((StringFormat)((StringFormat)Json.Companion.getNonstrict()), (MediaType)contentType)).client(PublishPlugin.Companion.buildOkHttpClient()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"Retrofit.Builder()\n     \u2026\n                .build()");
        PublishPlugin.retrofit = retrofit;
    }

    public static final /* synthetic */ void access$validateInputs(PublishPlugin $this, PublishPluginExtension amazon) {
        $this.validateInputs(amazon);
    }

    public static final /* synthetic */ void access$deleteExistingApksOnEdit(PublishPlugin $this, ApkService apkService, Edit activeEdit) {
        $this.deleteExistingApksOnEdit(apkService, activeEdit);
    }

    public static final /* synthetic */ void access$uploadApksAndAttachToEdit(PublishPlugin $this, ApkService apkService, Edit activeEdit, List apksToUpload) {
        $this.uploadApksAndAttachToEdit(apkService, activeEdit, apksToUpload);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lapp/brant/amazonappstorepublisher/PublishPlugin$Companion;", "", "()V", "apiVersion", "", "contentType", "Lokhttp3/MediaType;", "pluginDslRoot", "retrofit", "Lretrofit2/Retrofit;", "getRetrofit", "()Lretrofit2/Retrofit;", "buildOkHttpClient", "Lokhttp3/OkHttpClient;", "plugin"})
    public static final class Companion {
        @NotNull
        public final Retrofit getRetrofit() {
            return retrofit;
        }

        private final OkHttpClient buildOkHttpClient() {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
            httpClient.addInterceptor((Interceptor)logging);
            httpClient.writeTimeout(60L, TimeUnit.SECONDS);
            httpClient.readTimeout(30L, TimeUnit.SECONDS);
            OkHttpClient okHttpClient = httpClient.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"httpClient.build()");
            return okHttpClient;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

