package com.alan.alansdk.button;

import android.content.Context;
import android.os.PowerManager;

import com.alan.alansdk.logging.AlanLogger;

import static android.content.Context.POWER_SERVICE;

public class WakeLockManager {

    private Context context;
    private PowerManager.WakeLock wakeLock;

    public WakeLockManager(Context context) {
        this.context = context;
    }

    void acquireWakeLock() {
        if (wakeLock != null && wakeLock.isHeld()) {
            AlanLogger.w("Wakelock already acquired");
            return;
        }

        PowerManager powerManager = (PowerManager) context.getSystemService(POWER_SERVICE);
        wakeLock = powerManager.newWakeLock(PowerManager.SCREEN_DIM_WAKE_LOCK,
                "AlanSDK::ButtonWakeLock");
        wakeLock.acquire();
        AlanLogger.d("Wakelock acquired");
    }

    void releaseWakeLock() {
        if (wakeLock == null || !wakeLock.isHeld()) {
            return;
        }
        wakeLock.release();
        AlanLogger.d("Wakelock released");
    }

}
