package com.alan.alansdk.button;

import android.content.Context;
import android.media.MediaPlayer;

import androidx.annotation.RawRes;

import com.alan.alansdk.R;

public class SoundManager {

    private Context context;

    public SoundManager() {

    }

    public SoundManager(Context context) {
        this.context = context;
    }

    public void playNext() {
        playSound(R.raw.voice_notification_next);
    }

    public void playOff() {
        playSound(R.raw.voice_notification_off);
    }

    public void playOn() {
        playSound(R.raw.voice_notification_next);
    }

    private void playSound(@RawRes Integer audioRes) {
        MediaPlayer mediaPlayer = MediaPlayer.create(context, audioRes);
        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
            @Override
            public void onCompletion(MediaPlayer mp) {
                mp.release();
            }
        });
        mediaPlayer.start();
    }

}
