package com.alan.alansdk;

import androidx.annotation.NonNull;

import com.alan.alansdk.events.EventCommand;
import com.alan.alansdk.events.EventOptions;
import com.alan.alansdk.events.EventParsed;
import com.alan.alansdk.events.EventRecognised;
import com.alan.alansdk.events.EventText;

abstract public class AlanCallback {

    /**
     * Invokes on button state changed
     * @param alanState
     */
    public void onAlanStateChanged(final @NonNull AlanState alanState) {

    }

    /**
     * Invokes when user speech is recognized on backend
     * @param eventRecognised
     */
    public void onRecognizedEvent(final EventRecognised eventRecognised) {

    }

    public void onParsedEvent(EventParsed eventParsed) {

    }

    public void onOptionsReceived(final EventOptions eventOptions) {

    }

    /**
     * Invokes when some command from the script side is received
     * @param eventCommand
     */
    public void onCommandReceived(final EventCommand eventCommand) {

    }

    /**
     * Invokes on answer from the script
     * @param eventText
     */
    public void onTextEvent(final EventText eventText) {

    }

    /**
     * Invokes on any other event
     * @param event
     * @param payload
     */
    public void onEvent(final String event, final String payload) {

    }

    public void onError(final String error) {

    }
}
