package com.alan.alansdk.alanbase.speaker;

import android.os.Build;

import com.alan.alansdk.logging.AlanLogger;

public class AlanSpeaker implements SpeakerDumpListener {

    private SpeakerThread speakerThread;

    public void stopPlaying() {
        if (speakerThread == null) {
            return;
        }
        speakerThread.stopPlaying();
    }

    public void release() {
        if (speakerThread == null) {
            return;
        }
        try {
            speakerThread.release();
            speakerThread.join();
        } catch (InterruptedException e) {
            AlanLogger.e(e);
        }
    }

    public void startPlaying() {
        if (speakerThread == null || !speakerThread.isAlive()) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                speakerThread = new SpeakerApi23(this);
            } else {
                speakerThread = new SpeakerApi21(this);
            }
            speakerThread.start();
        }
        speakerThread.interrupt();
    }

    @Override
    public float[] retrieveAudioBuffer() {
        return readFrameNative();
    }

    private native float[] readFrameNative();
}
