/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.juddi.proxy.RegistryProxy;
import org.apache.ws.scout.registry.RegistryServiceImpl;

public class ConnectionImpl
implements Connection,
Serializable {
    private boolean closed = false;
    private boolean synchronous = true;
    private Set credentials;
    private final RegistryProxy registry;
    private final String postalScheme;
    private final int maxRows;

    public ConnectionImpl(URL queryManagerURL, URL lifeCycleManagerURL, String postalScheme, int maxRows) {
        Properties prop = new Properties();
        String transport = System.getProperty("juddi.proxy.transportClass");
        if (transport != null) {
            prop.setProperty("juddi.proxy.transportClass", transport);
        }
        this.registry = new RegistryProxy(prop);
        this.registry.setInquiryURL(queryManagerURL);
        this.registry.setPublishURL(lifeCycleManagerURL);
        this.postalScheme = postalScheme;
        this.maxRows = maxRows;
    }

    public RegistryService getRegistryService() throws JAXRException {
        RegistryServiceImpl reg = new RegistryServiceImpl(this.registry, this.postalScheme, this.maxRows);
        reg.setConnection(this);
        return reg;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Set getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Set credentials) {
        this.credentials = credentials;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

