/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.pm.xmldb;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.Element;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.ws.jaxme.JMHandler;
import org.apache.ws.jaxme.JMManager;
import org.apache.ws.jaxme.Observer;
import org.apache.ws.jaxme.PMException;
import org.apache.ws.jaxme.PMParams;
import org.apache.ws.jaxme.pm.impl.PMIdImpl;
import org.xml.sax.ContentHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XmlDbPM
extends PMIdImpl {
    private Class driverClass;
    private String collection;
    private String user;
    private String password;
    private Map databaseProperties;
    private String xPathQueryService = "XPathQueryService";
    private String xPathQueryServiceVersion = "1.0";

    public void init(JMManager pManager) throws JAXBException {
        Class<?> c;
        String p;
        String v;
        super.init(pManager);
        String driverClassName = pManager.getProperty("xmldb.driver");
        if (driverClassName == null || driverClassName.length() == 0) {
            throw new JAXBException("Missing property: 'xmldb.driver' (driver class name)");
        }
        String coll = pManager.getProperty("xmldb.collection");
        if (coll == null || coll.length() == 0) {
            throw new JAXBException("Missing property: 'xmldb.collection' (collection name)");
        }
        this.setCollection(coll);
        this.setUser(pManager.getProperty("xmldb.user"));
        this.setPassword(pManager.getProperty("xmldb.password"));
        int i = 0;
        while ((v = pManager.getProperty(p = "xmldb.property." + i)) != null) {
            int offset = v.indexOf(61);
            if (offset == -1) {
                throw new JAXBException("Invalid database property value " + p + ": Expected name=value, got " + v);
            }
            String name = v.substring(0, offset);
            String value = v.substring(offset + 1);
            if (this.databaseProperties != null) {
                this.databaseProperties = new HashMap();
            }
            this.databaseProperties.put(name, value);
            ++i;
        }
        try {
            c = Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                c = Thread.currentThread().getContextClassLoader().loadClass(driverClassName);
            }
            catch (ClassNotFoundException f) {
                throw new JAXBException("Failed to load driver class " + driverClassName, (Throwable)e);
            }
        }
        this.setDriverClass(c);
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String pCollection) {
        this.collection = pCollection;
    }

    public Class getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(Class pDriverClass) {
        this.driverClass = pDriverClass;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pPassword) {
        this.password = pPassword;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String pUser) {
        this.user = pUser;
    }

    public String getXPathQueryService() {
        return this.xPathQueryService;
    }

    public void setXPathQueryService(String pXpathQueryService) {
        this.xPathQueryService = pXpathQueryService;
    }

    public String getXPathQueryServiceVersion() {
        return this.xPathQueryServiceVersion;
    }

    public void setXPathQueryServiceVersion(String pXpathQueryServiceVersion) {
        this.xPathQueryServiceVersion = pXpathQueryServiceVersion;
    }

    protected Collection getXmlDbCollection() throws XMLDBException, IllegalAccessException, InstantiationException {
        Database database = (Database)this.getDriverClass().newInstance();
        if (this.databaseProperties != null) {
            Iterator iter = this.databaseProperties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                database.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        DatabaseManager.registerDatabase((Database)database);
        return DatabaseManager.getCollection((String)this.getCollection());
    }

    public void select(Observer pObserver, String pQuery, PMParams pPlaceHolderArgs) throws PMException {
        if (pPlaceHolderArgs != null) {
            pQuery = super.parseQuery(pQuery, pPlaceHolderArgs);
        }
        if (pQuery == null) {
            throw new IllegalArgumentException("A query must be specified");
        }
        try {
            ResourceIterator i;
            Collection col = this.getXmlDbCollection();
            XPathQueryService service = (XPathQueryService)col.getService(this.getXPathQueryService(), this.getXPathQueryServiceVersion());
            ResourceSet result = service.query(pQuery);
            if (result != null && (i = result.getIterator()).hasMoreResources()) {
                Class c = this.getManager().getHandlerClass();
                JMHandler handler = (JMHandler)c.newInstance();
                handler.setObserver(pObserver);
                while (i.hasMoreResources()) {
                    XMLResource r = (XMLResource)i.nextResource();
                    r.getContentAsSAX((ContentHandler)handler);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new PMException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PMException((Throwable)e);
        }
        catch (XMLDBException e) {
            throw new PMException((Throwable)e);
        }
    }

    public void insert(Element pElement) throws PMException {
        try {
            Collection col = this.getXmlDbCollection();
            String id = this.getId(pElement);
            XMLResource resource = (XMLResource)col.createResource(id, "XMLResource");
            ContentHandler ch = resource.setContentAsSAX();
            Marshaller marshaller = this.getManager().getFactory().createMarshaller();
            marshaller.marshal((Object)pElement, ch);
            col.storeResource((Resource)resource);
        }
        catch (XMLDBException e) {
            throw new PMException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PMException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PMException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new PMException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new PMException(e.getTargetException());
        }
        catch (JAXBException e) {
            if (e instanceof PMException) {
                throw (PMException)e;
            }
            throw new PMException((Throwable)e);
        }
    }

    public void update(Element pElement) throws PMException {
        try {
            Collection col = this.getXmlDbCollection();
            String id = this.getId(pElement);
            XMLResource resource = (XMLResource)col.getResource(id);
            ContentHandler ch = resource.setContentAsSAX();
            Marshaller marshaller = this.getManager().getFactory().createMarshaller();
            marshaller.marshal((Object)pElement, ch);
            col.storeResource((Resource)resource);
        }
        catch (XMLDBException e) {
            throw new PMException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PMException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PMException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new PMException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new PMException(e.getTargetException());
        }
        catch (JAXBException e) {
            if (e instanceof PMException) {
                throw (PMException)e;
            }
            throw new PMException((Throwable)e);
        }
    }

    public void delete(Element pElement) throws PMException {
        try {
            Collection col = this.getXmlDbCollection();
            String id = this.getId(pElement);
            XMLResource resource = (XMLResource)col.createResource(id, "XMLResource");
            col.removeResource((Resource)resource);
        }
        catch (XMLDBException e) {
            throw new PMException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PMException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PMException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new PMException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new PMException((Throwable)e);
        }
        catch (JAXBException e) {
            if (e instanceof PMException) {
                throw (PMException)e;
            }
            throw new PMException((Throwable)e);
        }
    }
}

