/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.pm.ino;

import java.util.List;
import org.apache.ws.jaxme.pm.ino.InoException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class InoResponseHandler
implements ContentHandler {
    public static final String INO_RESPONSE2_URI = "http://namespaces.softwareag.com/tamino/response2";
    public static final String XQL_URI = "http://metalab.unc.edu/xql/";
    private boolean inInoMessage = false;
    private boolean inInoMessageText;
    private boolean inXqlResult;
    private int level;
    private String inoErrorCode;
    private StringBuffer inoErrorMessage;
    private Locator locator;
    private ContentHandler resultHandler;
    private List inoObjectIdList;

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void startDocument() throws SAXException {
        this.inInoMessage = false;
        this.inInoMessageText = false;
        this.inXqlResult = false;
        this.level = 0;
        if (this.inoObjectIdList != null) {
            this.inoObjectIdList.clear();
        }
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attr) throws SAXException {
        if (this.inXqlResult) {
            if (this.resultHandler != null) {
                if (this.level == 2) {
                    this.resultHandler.startDocument();
                }
                this.resultHandler.startElement(namespaceUri, localName, qName, attr);
            }
        } else if (this.inInoMessage) {
            if (this.level == 2 && INO_RESPONSE2_URI.equals(namespaceUri) && "messagetext".equals(localName)) {
                String c = attr.getValue(INO_RESPONSE2_URI, "code");
                if (c != null) {
                    this.inoErrorCode = c;
                }
                this.inInoMessageText = true;
            }
        } else if (this.level == 1) {
            if (XQL_URI.equals(namespaceUri) && "result".equals(localName)) {
                this.inXqlResult = true;
            } else if (INO_RESPONSE2_URI.equals(namespaceUri)) {
                if ("message".equals(localName)) {
                    String retval = attr.getValue(INO_RESPONSE2_URI, "returnvalue");
                    if (retval == null || !retval.equals("0")) {
                        this.inoErrorCode = retval;
                        this.inoErrorMessage = new StringBuffer();
                        this.inInoMessage = true;
                    }
                } else if (this.inoObjectIdList != null && "object".equals(localName)) {
                    this.inoObjectIdList.add(attr.getValue(INO_RESPONSE2_URI, "id"));
                }
            }
        }
        ++this.level;
    }

    public void endElement(String namespaceUri, String localName, String qName) throws SAXException {
        --this.level;
        if (this.inXqlResult) {
            if (this.level == 1) {
                this.inXqlResult = false;
            } else if (this.resultHandler != null) {
                this.resultHandler.endElement(namespaceUri, localName, qName);
                if (this.level == 2) {
                    this.resultHandler.endDocument();
                }
            }
        } else if (this.inInoMessage) {
            if (this.level == 1) {
                if (this.inoErrorCode == null) {
                    this.inoErrorCode = "INOUNKNOWN";
                }
                throw new InoException(this.inoErrorCode, this.inoErrorMessage.toString());
            }
            if (this.level == 2 && this.inInoMessageText) {
                this.inInoMessageText = false;
            }
        }
    }

    public void startPrefixMapping(String namespaceUri, String prefix) throws SAXException {
        if (this.inXqlResult && this.resultHandler != null) {
            this.resultHandler.startPrefixMapping(namespaceUri, prefix);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.inXqlResult && this.resultHandler != null) {
            this.resultHandler.endPrefixMapping(prefix);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        if (this.inXqlResult && this.resultHandler != null) {
            this.resultHandler.ignorableWhitespace(ch, start, len);
        }
    }

    public void skippedEntity(String entity) throws SAXException {
        if (this.inXqlResult && this.resultHandler != null) {
            this.resultHandler.skippedEntity(entity);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.inXqlResult && this.resultHandler != null) {
            this.resultHandler.processingInstruction(target, data);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.inXqlResult) {
            if (this.resultHandler != null) {
                this.resultHandler.characters(ch, start, len);
            }
        } else if (this.inInoMessageText) {
            this.inoErrorMessage.append(ch, start, len);
        }
    }

    public void setResultHandler(ContentHandler handler) {
        this.resultHandler = handler;
    }

    public ContentHandler getResultHandler() {
        return this.resultHandler;
    }

    public void setInoObjectIdList(List pList) {
        this.inoObjectIdList = pList;
    }

    public List getInoObjectIdList() {
        return this.inoObjectIdList;
    }
}

