package annguyen.kotlin.request.promise

import kotlinx.coroutines.experimental.async
import kotlinx.coroutines.experimental.launch
import org.jdeferred.Deferred
import org.jdeferred.Promise
import org.jdeferred.impl.DeferredObject

/**
 * Created by annguyen on 1/30/18.
 */
object PromiseHelper {

    fun <D> create(process: OnProcessPromise<D>): Promise<D, Exception, Void> {
        val deferred = DeferredObject<D, Exception, Void>()
        process.setDeferred(deferred)
        process.process()
        return deferred.promise()
    }
}

class PromiseBuilder<T> {
    private lateinit var deferred: Deferred<T, Exception, Void>

    fun promise(builder: PromiseBuilder<T>.() -> Unit): Promise<T, Exception, Void> {
        deferred = DeferredObject<T, Exception, Void>()
        this.launcher(builder)
        return deferred.promise()
    }

    private fun launcher(builder: PromiseBuilder<T>.() -> Unit) {
        launch(Android) {
            async {
                builder()
            }.await()
        }
    }

    fun resolve(data: T) {
        if (!deferred.isResolved) {
            deferred.resolve(data)
        }
    }

    fun reject(exception: Exception) {
        if (!deferred.isRejected) {
            deferred.reject(exception)
        }
    }
}

fun <T> promise(builder: PromiseBuilder<T>.() -> Unit): Promise<T, Exception, Void> {
    return PromiseBuilder<T>().promise(builder)
}

abstract class OnProcessPromise<D> {

    private var promise: Deferred<D, Exception, Void>? = null

    fun setDeferred(deferred: Deferred<D, Exception, Void>) {
        this.promise = deferred
    }

    fun process() {
        launch(Android) {
            try {
                val deferred = getDeferredCallableObject()
                resolve(deferred.await())
            } catch (e: Exception) {
                e.printStackTrace()
                reject(e)
            }
        }
    }

    abstract fun getDeferredCallableObject(): kotlinx.coroutines.experimental.Deferred<D>

    fun resolve(data: D) {
        if (!promise?.isResolved!!)
            promise?.resolve(data)
    }

    fun reject(fail: Exception) {
        if (!promise?.isRejected!!)
            promise?.reject(fail)
    }
}