package annguyen.kotlin.request.json

import com.android.volley.NetworkResponse
import com.android.volley.ParseError
import com.android.volley.Response
import com.android.volley.toolbox.HttpHeaderParser
import com.android.volley.toolbox.JsonObjectRequest
import com.android.volley.toolbox.JsonRequest
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.UnsupportedEncodingException
import java.nio.charset.Charset

/**
 * Created by annguyen on 1/31/18.
 */
class JSONRequest : JsonObjectRequest {

    constructor(method: Int, url: String?, requestBody: JSONObject?, listener: Response.Listener<JSONObject>?, errorListener: Response.ErrorListener?) : super(method, url, requestBody, listener, errorListener)

    @Deprecated("Use {@link #JSONRequest(int, String, String, Listener, ErrorListener)}.")
    constructor(url: String?, requestBody: JSONObject?, listener: Response.Listener<JSONObject>?, errorListener: Response.ErrorListener?) : super(url, requestBody, listener, errorListener)

    override fun parseNetworkResponse(response: NetworkResponse?): Response<JSONObject> {
        return try {
            val jsonString = String(response?.data!!,
                    Charset.forName(HttpHeaderParser.parseCharset(response.headers, JsonRequest.PROTOCOL_CHARSET)))

            val responseString = "{'status': 200, 'data': $jsonString}"
            Response.success<JSONObject>(JSONObject(responseString),
                    HttpHeaderParser.parseCacheHeaders(response))
        } catch (e: UnsupportedEncodingException) {
            Response.error<JSONObject>(ParseError(e))
        } catch (je: JSONException) {
            Response.error<JSONObject>(ParseError(je))
        }
    }

    private fun isJSONArray(jsonString: String) : Boolean {
        return try {
            JSONArray(jsonString)
            true
        } catch (e : Exception) {
            false
        }
    }
}