package annguyen.kotlin.request.json

import org.json.JSONArray
import org.json.JSONObject
import java.util.*

/**
 * Created by annguyen on 3/10/18.
 */
class JSONObjectBuilder {
    private val deque: Deque<JSONObject> = ArrayDeque()

    fun json(build: JSONObjectBuilder.() -> Unit): JSONObject {
        deque.push(JSONObject())
        this.build()
        return deque.pop()
    }

    infix fun <T> String.To(value: T) {
        deque.peek().put(this, value)
    }

    fun arr(vararg args: Any) : JSONArray {
        val jsonArray = JSONArray()
        for (item in args) {
            jsonArray.put(item)
        }
        return jsonArray
    }
}

fun json(build: JSONObjectBuilder.() -> Unit): JSONObject {
    return JSONObjectBuilder().json(build)
}