package smkmobile.ratingview;

import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import butterknife.BindView;
import butterknife.ButterKnife;
import me.zhanghai.android.materialratingbar.MaterialRatingBar;
import smkmobile.helper.CommonHelper;

/**
 * Created by annguyen on 5/9/17.
 */

public class RateAppView extends LinearLayout {

    private static final String KEY_APP_NAME = "app_name";
    private static final String KEY_APP_ICON = "ic_launcher";

    private String mAppName = "";
    private int mAppIcon = -1;
    private String mTitle;
    private String mSubtitle;
    private String mButtonText;

    private boolean isShowSubtitle = true;
    private ColorStateList mTitleTextColor;
    private ColorStateList mSubTitleTextColor;
    private ColorStateList mButtonColor;
    private ColorStateList mButtonTextColor;
    private ColorStateList mStarColor;


    @BindView(R2.id.text_title)
    protected TextView mTextTitle;

    @BindView(R2.id.text_subtitle)
    protected TextView mTextSubtitle;

    @BindView(R2.id.img_left)
    protected ImageView mLeftImage;

    @BindView(R2.id.txt_button)
    protected AppCompatButton mButtonRate;

    @BindView(R2.id.rating_bar)
    protected MaterialRatingBar mRatingBar;

    private OnLayoutClickListener mLayoutClickListener;
    private OnButtonClickListener mButtonClickListener;

    public RateAppView(Context context) {
        super(context);
        initialize();
    }

    public RateAppView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initAttributes(attrs);
        initialize();
    }

    public RateAppView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initAttributes(attrs);
        initialize();
    }

    private void initialize() {
        initView();
        initButterKnife();
        initVariable();
        bindData();
        initEvent();
    }

    private void initView() {
        inflate(getContext(), R.layout.layout_rate_app_view, this);
    }

    private void initButterKnife() {
        ButterKnife.bind(this);
    }

    private void initVariable() {
        if (mAppName == null) {
            int appName = CommonHelper.getResourceIdByName(getContext(), KEY_APP_NAME, "string");
            if (appName > 0) {

                mAppName = getContext().getString(appName);
            }
        }

        if (mAppIcon == -1) {
            int appIcon = CommonHelper.getResourceIdByName(getContext(), KEY_APP_ICON, "mipmap");
            if (appIcon > 0) {
                mAppIcon = appIcon;
            }
        }
    }

    private void initAttributes(AttributeSet attrs) {
        TypedArray ta = getContext().obtainStyledAttributes(attrs, R.styleable.RateAppView, 0, 0);
        try {
            mAppName = ta.getString(R.styleable.RateAppView_app_name);
            mAppIcon = ta.getResourceId(R.styleable.RateAppView_app_img, -1);
            mTitle = ta.getString(R.styleable.RateAppView_text_title);
            mSubtitle = ta.getString(R.styleable.RateAppView_text_subtitle);
            isShowSubtitle = ta.getBoolean(R.styleable.RateAppView_show_subtitle, true);
            mButtonText = ta.getString(R.styleable.RateAppView_text_button);

            mButtonColor = ta.getColorStateList(R.styleable.RateAppView_button_color);
            mButtonTextColor = ta.getColorStateList(R.styleable.RateAppView_button_text_color);
            mTitleTextColor = ta.getColorStateList(R.styleable.RateAppView_title_color);
            mSubTitleTextColor = ta.getColorStateList(R.styleable.RateAppView_subtitle_color);
            mStarColor = ta.getColorStateList(R.styleable.RateAppView_star_color);

        } finally {
            ta.recycle();
        }

    }

    private void bindData() {
        setLeftImage(mAppIcon);

        String textRateApp = getResources().getString(R.string.text_please_rate_us, mAppName);
        if (mTitle == null)
            mTitle = textRateApp;

        if (mSubtitle == null)
            mSubtitle = textRateApp;

        setTitle(mTitle);
        setSubtitle(mSubtitle);

        if (!isShowSubtitle) {
            hideSubtitle();
        } else {
            showSubtitle();
        }

        if (mButtonText != null) {
            setButtonText(mButtonText);
        }

        if (mTitleTextColor == null) {
            mTitleTextColor = CommonHelper.getColorStateList(getContext(), R.color.text_title_color);
        }

        if (mSubTitleTextColor == null) {
            mSubTitleTextColor = CommonHelper.getColorStateList(getContext(), R.color.text_subtitle_color);
        }

        if (mStarColor == null) {
            mStarColor = CommonHelper.getColorStateList(getContext(), R.color.star_color);
        }

        if (mButtonColor == null) {
            mButtonColor = CommonHelper.getColorStateList(getContext(), R.color.rate_button_color);
        }

        if (mButtonTextColor == null) {
            mButtonTextColor = CommonHelper.getColorStateList(getContext(), android.R.color.white);
        }

        setTitleTextColor(mTitleTextColor);
        setSubTitleTextColor(mSubTitleTextColor);
        setRateStarColor(mStarColor);
        setButtonColor(mButtonColor);
        setButtonTextColor(mButtonTextColor);

    }

    private void initEvent() {
        getRootView().setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mLayoutClickListener != null) {
                    mLayoutClickListener.onLayoutClick();
                } else {
                    openStore();
                }

            }
        });

        mButtonRate.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mButtonClickListener != null) {
                    mButtonClickListener.onButtonClick();
                } else {
                    openStore();
                }
            }
        });
    }

    private void openStore() {
        CommonHelper.showStoreView(getContext(), getContext().getPackageName());
    }

    public void setLayoutClickListener(OnLayoutClickListener mLayoutClickListener) {
        this.mLayoutClickListener = mLayoutClickListener;
    }

    public void setButtonClickLisnter(OnButtonClickListener mButtonClickListener) {
        this.mButtonClickListener = mButtonClickListener;
    }

    public interface OnLayoutClickListener {
        void onLayoutClick();
    }

    public interface OnButtonClickListener {
        void onButtonClick();
    }

    public void showSubtitle() {
        mTextSubtitle.setVisibility(VISIBLE);
    }

    public void hideSubtitle() {
        mTextSubtitle.setVisibility(GONE);
    }

    public void setTitle(String title) {
        mTextTitle.setText(title);
    }

    public void setSubtitle(String title) {
        mTextSubtitle.setText(title);
    }

    public void setLeftImage(Bitmap bitmap) {
        mLeftImage.setImageBitmap(bitmap);
    }

    public void setLeftImage(int resId) {
        mLeftImage.setImageResource(resId);
    }

    public void setTitleTextColor(int color) {
        mTextTitle.setTextColor(color);
    }

    public void setTitleTextColor(ColorStateList color) {
        mTextTitle.setTextColor(color);
    }

    public void setSubTitleTextColor(int color) {
        mTextSubtitle.setText(color);
    }

    public void setSubTitleTextColor(ColorStateList color) {
        mTextSubtitle.setTextColor(color);
    }

    public void setButtonColor(int color) {
        mButtonRate.setSupportBackgroundTintList(ContextCompat.getColorStateList(getContext(), color));
    }

    public void setButtonColor(ColorStateList color) {
        mButtonRate.setSupportBackgroundTintList(color);
    }

    public void setButtonTextColor(int color) {
        mButtonRate.setTextColor(color);
    }

    public void setButtonTextColor(ColorStateList color) {
        mButtonRate.setTextColor(color);
    }

    public void setRateStarColor(int color) {
        mRatingBar.setProgressTintList(ContextCompat.getColorStateList(getContext(), color));
    }

    public void setRateStarColor(ColorStateList color) {
        mRatingBar.setProgressTintList(color);
    }

    public void setButtonText(String text) {
        mButtonRate.setText(text);
    }

    public void setRateStarNumber(float number) {
        mRatingBar.setRating(number);
    }
}
