package annguyen.loadingrecyclerview.content;

import android.support.annotation.LayoutRes;
import android.view.View;

import java.io.Serializable;

/**
 *
 * Created by annguyen on 7/20/17.
 */

public abstract class BaseContent implements Serializable {

    @LayoutRes
    public abstract int getViewLayout();

    public abstract void init(ContentViewHolder holder);

    public void bindViewHolder(ContentViewHolder holder, int position) {
        holder.getItemView().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onItemClick(v);
            }
        });
    }

    public abstract void onItemClick(View view);
}
