package annguyen.loadingrecyclerview.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;

import annguyen.loadingrecyclerview.content.BaseContent;
import annguyen.loadingrecyclerview.content.ContentViewHolder;

/**
 * 
 * Created by annguyen on 7/20/17.
 */

public class FlexibleContentAdapter extends RecyclerView.Adapter<ContentViewHolder> {

    private List<BaseContent> mListContent;

    public FlexibleContentAdapter() {
        mListContent = new ArrayList<>();
    }

//    private boolean isShowCurrentPlayingItem = false;

    private int mCurrentPlayingIndex = 0;

    @Override
    public ContentViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        int layoutId = mListContent.get(0).getViewLayout();
        return new ContentViewHolder(LayoutInflater.from(parent.getContext()).inflate(layoutId, parent, false));
    }

    @Override
    public void onBindViewHolder(ContentViewHolder holder, int position) {
        position = holder.getAdapterPosition();
        BaseContent content = mListContent.get(position);
        content.init(holder);
        content.bindViewHolder(holder, position);
//        if (isShowCurrentPlayingItem) {
//            if (position == mCurrentPlayingIndex) {
//                holder.getItemView().setBackgroundResource(R.color.color_content_selected_background);
//            } else {
//                holder.getItemView().setBackgroundResource(R.color.color_content_default_background);
//            }
//        }
    }

    @Override
    public int getItemCount() {
        return mListContent.size();
    }

    public void addContent(BaseContent item) {
        mListContent.add(item);
    }

    public void clear() {
        mListContent.clear();
    }

    public BaseContent getContent(int position) {
        return mListContent.get(position);
    }

//    public void setShowCurrentPlayingItem(boolean showCurrentPlayingItem) {
//        isShowCurrentPlayingItem = showCurrentPlayingItem;
//    }

    public int getCurrentPlayingIndex() {
        return mCurrentPlayingIndex;
    }

    public void setCurrentPlayingIndex(int mCurrentPlayingIndex) {
        this.mCurrentPlayingIndex = mCurrentPlayingIndex;
    }

    public int getItemPosition(BaseContent content) {
        return mListContent.indexOf(content);
    }

    public List<BaseContent> getListContent() {
        return mListContent;
    }
}
