package annguyen.loadingrecyclerview;

import android.content.Context;
import android.graphics.Color;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.wang.avi.AVLoadingIndicatorView;

/**
 *
 * Created by annguyen on 4/8/17.
 */

public class LoadingRecyclerView extends FrameLayout {

    RecyclerView mRecyclerView;

    AVLoadingIndicatorView mIndicator;

    RecyclerView.Adapter mAdapter;

    public LoadingRecyclerView(Context context) {
        super(context);
        initialize();
    }

    public LoadingRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initialize();
    }

    public LoadingRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize();
    }

    private void initialize() {
        // Init RecyclerView
        mRecyclerView = new RecyclerView(getContext());
        mRecyclerView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        ((ViewGroup) getRootView()).addView(mRecyclerView);

        // Init Indicator
        mIndicator = new AVLoadingIndicatorView(getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(80, 80);
        layoutParams.addRule(RelativeLayout.CENTER_IN_PARENT, RelativeLayout.TRUE);
        mIndicator.setLayoutParams(layoutParams);
        mIndicator.setIndicatorColor(Color.parseColor("#cccccc"));
        mIndicator.setIndicator(IndicatorIcon.BallBeatIndicator);
        RelativeLayout indicatorWrapper = new RelativeLayout(getContext());
        indicatorWrapper.setLayoutParams(new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        indicatorWrapper.addView(mIndicator);
        ((ViewGroup) getRootView()).addView(indicatorWrapper);

        initRecyclerView();
        hideIndicator();
    }

    private void initRecyclerView() {
        mRecyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        mRecyclerView.setItemViewCacheSize(10);
    }

    public LoadingRecyclerView setAdapter(RecyclerView.Adapter adapter) {
        this.mAdapter = adapter;
        this.mRecyclerView.setAdapter(mAdapter);
        return this;
    }

    public LoadingRecyclerView setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.setLayoutManager(layoutManager);
        return this;
    }

    public LoadingRecyclerView setDivider(RecyclerView.ItemDecoration itemDecoration) {
        this.mRecyclerView.addItemDecoration(itemDecoration);
        return this;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mRecyclerView.getLayoutManager();
    }

    public LoadingRecyclerView setOnScrollListener(RecyclerView.OnScrollListener listener) {
        this.mRecyclerView.addOnScrollListener(listener);
        return this;
    }

//    public void setIndicatorColor(int color) {
//        this.mIndicator.setIndicatorColor(color);
//    }

    public void showIndicator() {
        this.mIndicator.show();
        ((RelativeLayout) this.mIndicator.getParent()).setVisibility(VISIBLE);
    }

    public void hideIndicator() {
        ((RelativeLayout) this.mIndicator.getParent()).setVisibility(GONE);
        this.mIndicator.hide();
    }

    public void setIndicatorIcon(String indicatorName) {
        this.mIndicator.setIndicator(indicatorName);
    }

    public void setNestedScrollView(boolean isNestedScroll) {
        this.mRecyclerView.setNestedScrollingEnabled(isNestedScroll);
    }

//    public void notifyDataSetChange() {
//        mAdapter.notifyDataSetChanged();
//    }
//
//    public void notifyItemRangeChanged(int startIndex, int numberItem) {
//        mAdapter.notifyItemRangeChanged(startIndex, numberItem);
//    }
}
