package annguyen.gifticon;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Toast;

import com.sackcentury.shinebuttonlib.ShineButton;

import java.util.concurrent.TimeUnit;

import io.github.douglasjunior.androidSimpleTooltip.SimpleTooltip;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

/**
 * Created by annguyen on 10/3/17.
 */

public class GiftIconView extends ShineButton {

    private Disposable mAnimationDisposable;
    private Observable mRepeatAnimationObservable;

    private SimpleTooltip mTooltip;
    private String mPackageId = "";

    public GiftIconView(Context context) {
        super(context);
        initialize();
    }

    public GiftIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initialize();
    }

    public GiftIconView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize();
    }

    private void initialize() {
        mRepeatAnimationObservable =
                Observable
                        .interval(0, 1500, TimeUnit.MILLISECONDS)
                        .observeOn(AndroidSchedulers.mainThread());

        setAllowRandomColor(true);
        enableFlashing(true);
        setAnimDuration(2000);
        setShineCount(10);
        setShineDistanceMultiple(1.5f);
        setShineTurnAngle(10f);
        setSmallShineOffAngle(10f);


        setOnClickListener(new OnButtonClickListener() {
            @Override
            public void onClick(View view) {
                getContext().startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + mPackageId)).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
            }
        });
    }

    public void setPackageId(String packageId) {
        mPackageId = packageId;
    }

    public void start() {
        if (mAnimationDisposable == null || mAnimationDisposable.isDisposed()) {
            mAnimationDisposable = mRepeatAnimationObservable.subscribe(new Consumer() {
                @Override
                public void accept(Object o) throws Exception {
                    showAnim();
                }
            });
        }
    }

    public void stop() {
        if (mAnimationDisposable != null && !mAnimationDisposable.isDisposed()) {
            mAnimationDisposable.dispose();
        }
    }

    public void initTooltip(String tooltipText, View targetView, int gravity, int backgroundColor, int textColor) {
        mTooltip = new SimpleTooltip.Builder(getContext())
                .anchorView(targetView)
                .text(tooltipText)
                .gravity(gravity)
                .animated(true)
                .backgroundColor(backgroundColor)
                .textColor(textColor)
                .arrowColor(backgroundColor)
                .dismissOnOutsideTouch(false)
                .dismissOnInsideTouch(false)
                .transparentOverlay(true)
                .build();
    }

    public void showTooltip() {
        if (!mTooltip.isShowing()) {
            mTooltip.show();
        }
    }

    public void hideTooltip() {
        if (mTooltip.isShowing()) {
            mTooltip.dismiss();
        }
    }

}
