package annguyen.gifticon;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Toast;

import com.sackcentury.shinebuttonlib.ShineButton;

import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

/**
 * Created by annguyen on 10/3/17.
 */

public class GiftIconView extends ShineButton {

    private Disposable mAnimationDisposable;
    private Observable mRepeatAnimationObservable;
    private OnGiftButtonClickListener listener;

    public GiftIconView(Context context) {
        super(context);
        initialize();
    }

    public GiftIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initialize();
    }

    public GiftIconView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize();
    }

    private void initialize() {
        mRepeatAnimationObservable =
                Observable
                        .interval(0, 1500, TimeUnit.MILLISECONDS)
                        .observeOn(AndroidSchedulers.mainThread());

        setAllowRandomColor(true);
        enableFlashing(true);
        setAnimDuration(2000);
        setShineCount(10);
        setShineDistanceMultiple(1.5f);
        setShineTurnAngle(10f);
        setSmallShineOffAngle(10f);


        setOnClickListener(new OnButtonClickListener() {
            @Override
            public void onClick(View view) {
                if (listener != null)
                    listener.onClick();
            }
        });
    }

    public void start() {
        if (mAnimationDisposable == null || mAnimationDisposable.isDisposed()) {
            mAnimationDisposable = mRepeatAnimationObservable.subscribe(new Consumer() {
                @Override
                public void accept(Object o) throws Exception {
                    showAnim();
                }
            });
        }
    }

    public void stop() {
        if (mAnimationDisposable != null && !mAnimationDisposable.isDisposed()) {
            mAnimationDisposable.dispose();
        }
    }

    public void setOnGiftButtonClickListener(OnGiftButtonClickListener listener) {
        this.listener = listener;
    }

    public interface OnGiftButtonClickListener {
        void onClick();
    }

}
