package annguyen.facebookembedview;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Field;

import annguyen.request.model.RequestModel;

/**
 * Created by annguyen on 11/7/17.
 */

public class FacebookPageModel extends RequestModel {

    private String mPageId;
    private String mPageCoverUrl;
    private String mPagePhotoUrl;
    private String mPageName;
    private String mPageLink;
    private String mPageCategory;
    private String mPageMission;

    public FacebookPageModel(JSONObject data) {
        super(data);
    }

    @Override
    protected void setFieldValue(Field field, Object value) throws IllegalAccessException {
        try {
            switch (field.getName()) {
                case "mPageCoverUrl":
                    if (value != null) {
                        super.setFieldValue(field, ((JSONObject) value).getString("source"));
                    }
                    break;
                case "mPagePhotoUrl":
                    if (value != null) {
                        super.setFieldValue(field, ((JSONObject) value).getJSONObject("data").getString("url"));
                    }
                    break;
                case "mPageLink":
                    if (value != null) {
                        super.setFieldValue(field, ((JSONObject) value).getJSONArray("android").getJSONObject(0).getString("url"));
                    }
                    break;
                default:
                    super.setFieldValue(field, value);
                    break;
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getVariableName(String key) {
        switch (key) {
            case "id":
                return "mPageId";
            case "cover":
                return "mPageCoverUrl";
            case "name":
                return "mPageName";
            case "picture":
                return "mPagePhotoUrl";
            case "app_links":
                return "mPageLink";
            default:
                return "mPage" + key.substring(0, 1).toUpperCase() + key.substring(1);
        }
    }

    public String getPageId() {
        return mPageId;
    }

    public String getPageCoverUrl() {
        return mPageCoverUrl;
    }

    public String getPagePhotoUrl() {
        return mPagePhotoUrl;
    }

    public String getPageName() {
        return mPageName;
    }

    public String getPageLink() {
        return mPageLink;
    }

    public String getPageCategory() {
        return mPageCategory;
    }

    public String getPageMission() {
        return mPageMission;
    }
}
