package annguyen.facebookembedview;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.net.Uri;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.view.SimpleDraweeView;

import org.json.JSONObject;

import annguyen.request.callback.BaseCallback;
import annguyen.request.request.HTTPRequest;
import annguyen.request.request.Headers;

/**
 * Created by annguyen on 11/7/17.
 */

public class FacebookPageEmbedView extends RelativeLayout implements View.OnClickListener {

    private final String mDefaultURL = "https://graph.facebook.com/{pageId}?access_token=1446487392044179|bef711d01879026d85a21d9b48c40aac&fields=cover,name,picture.type(normal),app_links,category,mission";

    private String mPageId = "";
    private FacebookPageModel mFacebookPage;

    public FacebookPageEmbedView(Context context) {
        super(context);
        initialize();
    }

    public FacebookPageEmbedView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initAttributes(attrs);
        initialize();
    }

    public FacebookPageEmbedView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initAttributes(attrs);
        initialize();
    }

    public FacebookPageEmbedView setPageId(String pageId) {
        mPageId = pageId;
        return this;
    }

    public void init() {
        initialize();

    }

    private void initAttributes(AttributeSet attributeSet) {
        TypedArray a = getContext().getTheme().obtainStyledAttributes(
                attributeSet,
                R.styleable.FacebookPageEmbedView,
                0, 0);

        try {
            mPageId = a.getString(R.styleable.FacebookPageEmbedView_pageId);
        } finally {
            a.recycle();
        }

    }

    private void initialize() {
        if (!Fresco.hasBeenInitialized()) {
            Fresco.initialize(getContext());
        }
        inflate(getContext(), R.layout.layout_facebook_page_embed_view, this);
        if (!mPageId.equals("")) {
            HTTPRequest.get(mDefaultURL.replace("{pageId}", mPageId), null, new BaseCallback() {
                @Override
                public void onSuccess(int statusCode, Headers headers, JSONObject response) {
                    mFacebookPage = new FacebookPageModel(response);
                    render();
                }
            });
        }
        setOnClickListener(this);
    }

    private void render() {
        ((TextView) findViewById(R.id.view_page_name)).setText(mFacebookPage.getPageName());
        ((TextView) findViewById(R.id.view_page_mission)).setText(mFacebookPage.getPageMission());
        ((TextView) findViewById(R.id.view_page_category)).setText("@" + mFacebookPage.getPageCategory());
        ((SimpleDraweeView) findViewById(R.id.view_page_cover)).setImageURI(mFacebookPage.getPageCoverUrl());
        ((SimpleDraweeView) findViewById(R.id.view_page_avatar)).setImageURI(mFacebookPage.getPagePhotoUrl());
        findViewById(R.id.view_button_like).setOnClickListener(this);
    }


    @Override
    public void onClick(View v) {
        Intent intent = getContext().getPackageManager().getLaunchIntentForPackage("com.facebook.katana");
        if (intent == null) {
            intent = new Intent(Intent.ACTION_VIEW, Uri.parse("https://facebook.com/" + mPageId));
        } else {
            intent = new Intent(Intent.ACTION_VIEW, Uri.parse(mFacebookPage.getPageLink()));
        }
        getContext().startActivity(intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
    }
}
