package annguyen.music.equalizer;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.LinearLayout;
import android.widget.TextView;

import org.adw.library.widgets.discreteseekbar.DiscreteSeekBar;


/**
 * Created by annguyen on 10/27/17.
 */

public class EqualizerBar extends LinearLayout implements DiscreteSeekBar.OnProgressChangeListener {

    private DiscreteSeekBar mFrequencySeekBar;
    private TextView mTextFrequencyNumber;
    private OnFrequencyValueChangeListener mListener;
    private short mFrequencyBand;

    public EqualizerBar(Context context) {
        super(context);
        initialize();
    }

    public EqualizerBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initialize();
    }

    public EqualizerBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize();
    }

    private void initialize() {
        inflate(getContext(), R.layout.layout_equalizer_bar, this);

        initialVariable();
        initialViewComponent();
    }

    private void initialViewComponent() {
        mFrequencySeekBar = findViewById(R.id.view_equalizer_seek_bar);
        mTextFrequencyNumber = findViewById(R.id.view_text_band_frequent);
        mFrequencySeekBar.setOnProgressChangeListener(this);
    }

    private void initialVariable() {

    }

    public void setFrequencyNumber(int frequencyNumber) {
        if (frequencyNumber < 1000) {
            mTextFrequencyNumber.setText(String.valueOf(frequencyNumber) + "Hz");
        } else if (frequencyNumber < 1000000) {
            mTextFrequencyNumber.setText((frequencyNumber / 1000) + "KHz");
        } else {
            mTextFrequencyNumber.setText((frequencyNumber / 1000000) + "MHz");
        }
    }

    public void setFrequencyValueRange(int min, int max) {
        if (min < max) {
            mFrequencySeekBar.setMax(max);
            mFrequencySeekBar.setMin(min);
        } else {
            Log.e("WrongValueException", "Min value is larger than max value");
        }
    }

    public void setOnFrequencyValueChangeListener(OnFrequencyValueChangeListener listener) {
        mListener = listener;
    }

    public void setFrequencyBand(short frequencyBand) {
        mFrequencyBand = frequencyBand;
    }

    public void setFrequencyNumber(short frequencyNumber) {
        mFrequencySeekBar.setProgress(frequencyNumber);
    }

    @Override
    public void onProgressChanged(DiscreteSeekBar seekBar, int value, boolean fromUser) {
        if (fromUser && mListener != null) {
            mListener.onFrequencyValueChanged(mFrequencyBand, (short) value);
        }
    }

    @Override
    public void onStartTrackingTouch(DiscreteSeekBar seekBar) {

    }

    @Override
    public void onStopTrackingTouch(DiscreteSeekBar seekBar) {

    }

    public interface OnFrequencyValueChangeListener {
        void onFrequencyValueChanged(short band, short frequency);
    }

    public short getFrequencyBand() {
        return mFrequencyBand;
    }
}
