package annguyen.music.equalizer;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;

import com.robertlevonyan.views.chip.Chip;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Created by annguyen on 10/31/17.
 */

public class CustomChip extends Chip {

    private boolean isSelected = false;
    private int mDisabledBackgroundColor = -1;
    private int mDisabledTextColor = -1;
    private int mSelectedBackgroundColor = -1;
    private int mSelectedTextColor = -1;
    private int mDefaultBackgroundColor = -1;
    private int mDefaultTextColor = -1;

    private short mPresetNumber;

    public CustomChip(Context context) {
        super(context);
        init(null);
    }

    public CustomChip(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(attrs);
    }

    public CustomChip(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void init(AttributeSet attributeSet) {
        try {
            Method method = Chip.class.getDeclaredMethod("initTypedArray", AttributeSet.class);
            method.setAccessible(true);
            method.invoke(this, attributeSet);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        setPadding(20, 20, 20, 20);

        mDisabledBackgroundColor = Color.parseColor("#30000000");
        mDisabledTextColor = Color.parseColor("#60FFFFFF");

        mDefaultTextColor = getTextColor();
        mDefaultBackgroundColor = getBackgroundColor();

    }

    public CustomChip build() {
        try {
            Method method = Chip.class.getDeclaredMethod("buildView");
            method.setAccessible(true);
            method.invoke(this);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void setChipSelected(boolean isSelected) {
        try {
            Field field = Chip.class.getDeclaredField("clicked");
            field.setAccessible(true);
            field.set(this, isSelected);
            callMethodNoParams("initBackgroundColor");
            callMethodNoParams("initTextView");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void callMethodNoParams(String methodName) {
        try {
            Method method = Chip.class.getDeclaredMethod(methodName);
            method.setAccessible(true);
            method.invoke(this);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changeBackgroundColor(int backgroundColor) {
        super.changeBackgroundColor(backgroundColor);
        mDefaultBackgroundColor = backgroundColor;
    }

    @Override
    public void setTextColor(int textColor) {
        super.setTextColor(textColor);
        mDefaultTextColor = textColor;
    }

    @Override
    public void changeSelectedBackgroundColor(int selectedBackgroundColor) {
        super.changeSelectedBackgroundColor(selectedBackgroundColor);
        mSelectedBackgroundColor = selectedBackgroundColor;
    }

    @Override
    public void setSelectedTextColor(int selectedTextColor) {
        super.setSelectedTextColor(selectedTextColor);
        mSelectedTextColor = selectedTextColor;
    }

    public void setPresetNumber(short presetNumber) {
        mPresetNumber = presetNumber;
    }

    public short getPresetNumber() {
        return mPresetNumber;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            super.setSelectedTextColor(mSelectedTextColor);
            super.changeSelectedBackgroundColor(mSelectedBackgroundColor);
            super.changeBackgroundColor(mDefaultBackgroundColor);
            super.setTextColor(mDefaultTextColor);
        } else {
            super.setSelectedTextColor(mDisabledTextColor);
            super.changeSelectedBackgroundColor(mDisabledBackgroundColor);
            super.changeBackgroundColor(mDisabledBackgroundColor);
            super.setTextColor(mDisabledTextColor);
        }

        callMethodNoParams("initBackgroundColor");
        callMethodNoParams("initTextView");
    }
}
