package annguyen.music.equalizer;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;

import com.google.android.flexbox.FlexboxLayout;
import com.robertlevonyan.views.chip.Chip;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by annguyen on 10/31/17.
 */

public class ChipsView extends FlexboxLayout implements Chip.OnClickListener {

    private List<CustomChip> mChipList;
    private OnChipsSelectedChangeListener mListener;


    public ChipsView(Context context) {
        super(context);
        initialize();
    }

    public ChipsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initialize();
    }

    public ChipsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize();
    }

    private void initialize() {
        mChipList = new ArrayList<>();
    }

    public void addChip(CustomChip chip) {
        addView(chip);
        chip.setOnClickListener(this);
        mChipList.add(chip);
    }

    @Override
    public void onClick(View view) {
        CustomChip currentChip = (CustomChip) view;
        for (CustomChip chip : mChipList) {
            if (chip != currentChip) {
                chip.setChipSelected(false);
            } else {
                chip.setChipSelected(true);
            }
        }
//        currentChip.setChipSelected(true);
        if (mListener != null)
            mListener.onChipChange((CustomChip) view);
    }

    public void setChipSelectedChangeListener(OnChipsSelectedChangeListener listener) {
        mListener = listener;
    }

    public interface OnChipsSelectedChangeListener {
        void onChipChange(CustomChip chip);
    }

    public void setSelectedChip(int position) {
        mChipList.get(position).setChipSelected(true);
        if (mListener != null) {
            mListener.onChipChange(mChipList.get(position));
        }
    }

    public void setSelectedChip(short presetNumber) {
        for (CustomChip chip : mChipList) {
            if (chip.getPresetNumber() == presetNumber) {
                chip.setChipSelected(true);
                if (mListener != null) {
                    mListener.onChipChange(chip);
                }
            }
        }
    }
}
