package annguyen.request.request;

import java.util.HashMap;
import java.util.List;
import java.util.Set;

/**
 *
 * Created by annguyen on 3/12/17.
 */

public class RequestParams {
    private HashMap<String, String> params;

    public RequestParams() {
        params = new HashMap<>();
    }

    public RequestParams put(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public RequestParams put(String key, RequestParams values) {
        for (String paramKey: values.keys()) {
            key += "[" + paramKey + "]";
            put(key, values.get(paramKey));
        }
        return this;
    }

    public RequestParams put(String key, List<Object> values) {
        for (Object value : values) {
            if (value instanceof String) {
                key += "[]";
                put(key, String.valueOf(value));
            } else if (value instanceof RequestParams) {
                put(key, (RequestParams) value);
            }
        }
        return this;
    }

    public String get(String key) {
        return this.params.get(key);
    }

    public Set<String> keys() {
        return this.params.keySet();
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }
}
