package annguyen.request.request;

import android.support.annotation.Nullable;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.HurlStack;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.NoCache;
import com.android.volley.toolbox.RequestFuture;

import org.json.JSONObject;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import annguyen.request.callback.BaseCallback;


/**
 * Created by annguyen on 3/8/17.
 */

public class HTTPRequest {
    /**
     * PRIVATE VARIABLE
     */
    private static RequestQueue mRequestQueue = init();

    private static RequestQueue init() {
        mRequestQueue = new RequestQueue(new NoCache(), new BasicNetwork(new HurlStack()));
        mRequestQueue.start();
        return mRequestQueue;
    }

    /**
     * PUBLIC FUNCTION
     */

    public static void get(String uri, @Nullable RequestParams params, BaseCallback callback) {
        if (params == null)
            params = new RequestParams();
        
        uri = BaseRequest.parseParamsToURL(uri, params);
        BaseRequest request = new BaseRequest(Request.Method.GET, uri, params, callback);
        mRequestQueue.add(request);
    }

    public static void get(String uri, @Nullable RequestParams params, @Nullable Headers headers, BaseCallback callback) {
        if (params == null)
            params = new RequestParams();

        uri = BaseRequest.parseParamsToURL(uri, params);
        BaseRequest request = new BaseRequest(Request.Method.GET, uri, params, headers, callback);
        mRequestQueue.add(request);
    }

    public static JSONObject get(String uri) {
        RequestFuture<JSONObject> future = RequestFuture.newFuture();
        JsonObjectRequest request = new JsonObjectRequest(uri, null, future, future);
        mRequestQueue.add(request);

        try {
            return future.get(3, TimeUnit.SECONDS); // this will block
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        } catch (TimeoutException e) {
            e.printStackTrace();
        }
        return null;
    }

//    public  static void post(String uri, RequestParams params, BaseCallback callback) {
////        StringRequest request = new StringRequest(Request.Method.POST, uri, callback, null);
//
//    }


}
