package annguyen.request.request;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

import annguyen.request.callback.BaseCallback;


/**
 * Created by annguyen on 7/17/17.
 */

public class BaseRequest extends Request<BaseResponse> {

    private Map<String, String> mParams;
    private BaseCallback mSuccessListener;
    private Map<String, String> mHeaders;

    public BaseRequest(int method, String url, RequestParams params, BaseCallback listener) {
        super(method, url, listener);
        mParams = params.getParams();
        mSuccessListener = listener;
    }

    public BaseRequest(int method, String url, RequestParams params, Headers headers, BaseCallback mSuccessListener) {
        super(method, url, mSuccessListener);
        mParams = params.getParams();
        this.mSuccessListener = mSuccessListener;
        mHeaders = headers.getHeaders();
    }

    @Override
    protected Response<BaseResponse> parseNetworkResponse(NetworkResponse response) {
        String parsed;
        try {
            parsed = new String(response.data, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return Response.success(new BaseResponse(response.headers, parsed, response.statusCode), HttpHeaderParser.parseCacheHeaders(response));
    }

    @Override
    protected void deliverResponse(BaseResponse response) {
        mSuccessListener.onResponse(response);
    }

    @Override
    public void deliverError(VolleyError error) {
        super.deliverError(error);
    }

    @Override
    protected Map<String, String> getParams() throws AuthFailureError {
        return mParams;
    }

    static String parseParamsToURL(String url, RequestParams params) {
        if (params == null || params.getParams().size() == 0)
            return url;

        StringBuilder encodedParams = new StringBuilder();
        for (Map.Entry<String, String> entry : params.getParams().entrySet()) {
            try {
                encodedParams.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                encodedParams.append('&');
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        encodedParams.deleteCharAt(encodedParams.length() - 1);
        if (url.contains("?")) {
            return url + "&" + encodedParams.toString();
        }
        return url + "?" + encodedParams.toString();
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {
        if (mHeaders == null)
            return super.getHeaders();
        return mHeaders;
    }
}
