package annguyen.request.model;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Field;
import java.util.Iterator;

/**
 * Created by annguyen on 7/17/17.
 */

public abstract class RequestModel {

    public static String MODEL_NAME;

    protected Integer mId;

    public RequestModel(int id) {
        mId = id;
    }

    public RequestModel(JSONObject data) {
        try {
            init(data);
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void init(JSONObject data) throws JSONException, IllegalAccessException {
        Iterator<String> keys = data.keys();
        for (;keys.hasNext();) {
            String key = keys.next();
            if (key.equals("_id")) {
                mId = data.getInt(key);
            } else {
                String variableName = getVariableName(key);
                Field variable = getField(variableName);
                if (variable != null) {
                    variable.setAccessible(true);
                    setFieldValue(variable, data.get(key));
                }
            }
        }
    }

    protected String getVariableName(String key) {
        String variableName = "m";

        key = key.substring(0, 1).toUpperCase() + key.substring(1);

        variableName += key;
        return variableName;
    }

    protected Field getField(String name) {
        try {
            return getClass().getDeclaredField(name);
        } catch (Exception e) {
            return null;
        }
    }

    protected void setFieldValue(Field field, Object value) throws IllegalAccessException {
        if (value != null && !value.toString().equals("null"))
            field.set(this, value);
    }

    public Integer getId() {
        return mId;
    }
}
