package annguyen.request.callback;

import android.util.Log;

import com.android.volley.Response;
import com.android.volley.VolleyError;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import annguyen.request.Common;
import annguyen.request.request.BaseResponse;
import annguyen.request.request.Headers;


/**
 * Created by annguyen on 7/17/17.
 */

public abstract class BaseCallback implements Response.Listener<BaseResponse>, Response.ErrorListener {
    @Override
    public void onErrorResponse(VolleyError error) {
        String errorMessage = error.getMessage();
        if (errorMessage == null)
            errorMessage = error.getClass().toString();
        Log.i("VolleyError", errorMessage);
    }

    @Override
    public void onResponse(BaseResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            Log.i("VolleyRequest", "SendRequestFailed");
            Log.i("VolleyRequest", "Status:" + statusCode);
            if (response.getResponseBody() != null) {
                Log.i("VolleyRequest", "ResponseBody:" + response.getResponseBody());
            }
        } else {
            String body = response.getResponseBody();
            Headers headers = response.getHeader();
            if (Common.isJSONArrayString(body)) {
                try {
                    onSuccess(statusCode, headers, new JSONArray(body));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            } else if (Common.isJSONObjectString(body)) {
                try {
                    onSuccess(statusCode, headers, new JSONObject(body));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            body = null;
        }
    }

    public void onSuccess(int statusCode, Headers headers, JSONObject response){
        // Waiting for Override
    }

    public void onSuccess(int statusCode, Headers headers, JSONArray response) {
        // Waiting for override
    }
}
