package android.slc.code.ui.activity;

import android.os.Bundle;
import android.slc.code.vm.BaseViewModel;

import androidx.annotation.Nullable;
import androidx.databinding.ViewDataBinding;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * 此类是为了兼容0.2.9版本，需要主义的是，如果你重写了initViewModel方法，可能会存在兼容性问题，没有可以忽略。
 * 除上述问题外，部分方法声明类型也需要稍作调整
 *
 * @author slc
 * @date 2021/2/6 11:41
 */
public abstract class MvvmCompatV029Activity<V extends ViewDataBinding, VM extends BaseViewModel> extends MvvmActivity<V> {
    protected VM viewModel;

    @Override
    protected void initViewDelegate(@Nullable Bundle savedInstanceState) {
        super.initViewDelegate(savedInstanceState);
    }

    /**
     * 初始化dataBind
     */
    @SuppressWarnings("unchecked")
    @Override
    public void initViewModel() {
        viewModel = getVmByActivityProvider(getThisVmClass());
        registerLiveEvent();
        registerMvvmViewShank();
        if (getDataBinding() != null) {
            bindingVariable();
        }
    }

    /**
     * 获取当前的VmClass
     * @return
     */
    protected Class<VM> getThisVmClass() {
        Type type = getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return (Class<VM>) ((ParameterizedType) type).getActualTypeArguments()[1];
        } else {
            //如果没有指定泛型参数，则默认使用BaseViewModel
            return (Class<VM>) BaseViewModel.class;
        }
    }

    /**
     * 注册LiveEvent事件
     */
    protected void registerLiveEvent() {
        registerLiveEvent(viewModel);
    }

    /**
     * 注册 MvvmViewShank
     */
    protected void registerMvvmViewShank() {
        registerMvvmViewShank(viewModel);
    }

    /**
     * 绑定Variable
     */
    protected abstract void bindingVariable();

}