package android.slc.code.ui.fragment;

import android.slc.code.vm.BaseViewModel;

import androidx.databinding.ViewDataBinding;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * 此类是为了兼容0.2.9版本，需要主义的是，如果你重写了initViewModel方法，可能会存在兼容性问题，没有可以忽略。
 * 除上述问题外，部分方法声明类型也需要稍作调整
 *
 * @author slc
 * @date 2021/2/6 11:41
 */
public abstract class MvvmCompatV029Fragment<V extends ViewDataBinding, VM extends BaseViewModel> extends MvvmFragment<V> {
    protected VM viewModel;

    /**
     * 初始化dataBind
     */
    @SuppressWarnings("unchecked")
    @Override
    public void initViewModel() {
        Class<VM> modelClass;
        Type type = getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            modelClass = (Class<VM>) ((ParameterizedType) type).getActualTypeArguments()[1];
        } else {
            //如果没有指定泛型参数，则默认使用BaseViewModel
            modelClass = (Class<VM>) BaseViewModel.class;
        }
        viewModel = getVmByFragmentProvider(modelClass);
        registerLiveEvent();
        registerMvvmViewShank();
        if (getDataBinding() != null) {
            bindingVariable();
        }
    }

    /**
     * 注册LiveEvent事件
     */
    protected void registerLiveEvent() {
        registerLiveEvent(viewModel);
    }

    /**
     * 注册 MvvmViewShank
     */
    protected void registerMvvmViewShank() {
        registerMvvmViewShank(viewModel);
    }

    /**
     * 绑定Variable
     */
    protected abstract void bindingVariable();

}